import React from 'react';
import {
    Document,
    Page,
    View,
    Text,
    StyleSheet,
    Image,
} from '@react-pdf/renderer';
import logo from '../../assets/Images/logo.png';

const styles = StyleSheet.create({
    page: {
        padding: 30,
        fontSize: 11,
        fontFamily: 'Helvetica',
        color: '#333',
    },
    header: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center',
    },
    logo: {
        width: 140,
        height: 40,
    },
    invoiceTitle: {
        fontSize: 24,
        fontWeight: 'bold',
        color: '#0046AE',
    },
    section: {
        marginTop: 20,
        width: '100%',
    },
    subtitle: {
        fontSize: 13,
        fontWeight: 'bold',
        color: '#0046AE',
        marginBottom: 10,
    },
    badgeRow: {
        flexDirection: 'row',
        gap: 10,
        marginVertical: 6,
        width: '100%',
    },
    badge: {
        paddingHorizontal: 10,
        paddingVertical: 4,
        borderRadius: 4,
        fontSize: 10,
        color: 'white',
    },
    paid: {
        backgroundColor: '#28B765',
    },
    stripe: {
        backgroundColor: '#0046AE',
    },
    box: {
        border: '1px solid #ccc',
        borderRadius: 5,
        padding: 10,
    },
    table: {
        marginTop: 10,
        border: '1px solid #ccc',
        borderRadius: 5,
    },
    tableRowHeader: {
        flexDirection: 'row',
        backgroundColor: '#D3D3D3',
        padding: 6,
        fontWeight: 'bold',
    },
    tableRow: {
        flexDirection: 'row',
        padding: 6,
        borderTop: '1px solid #ccc',
    },
    colSL: { width: '10%' },
    colSponsor: { width: '20%' },
    colStore: { width: '20%' },
    colDays: { width: '10%' },
    colPrice: { width: '10%' },
    colStart: { width: '15%' },
    colEnd: { width: '15%' },
});

const InvoiceDocumentSponcer = ({ data }: { data: any }) => {
    const sponsor = data?.view_sponser || {};


    console.log("sponsorsfdfasdfasdfdasfsdf" ,sponsor)

    return (
        <Document>
            <Page size="A4" style={styles.page}>
                {/* Header */}
                <View style={styles.header}>
                    <Image src={logo} style={styles.logo} />
                    <Text style={styles.invoiceTitle}>INVOICE</Text>
                </View>

                {/* Goal Payment Info & Vendor Details */}
                <View style={styles.badgeRow}>
                    {/* Goal Payment Info */}
                    <View style={styles.section}>
                        <Text style={styles.subtitle}>Goal Payment Information</Text>
                        <View style={styles.box}>
                            <Text>Goal Payment ID: #{sponsor.goal_payment_id}</Text>
                            <Text>Payment Date: {sponsor.payment_date}</Text>
                            <View style={styles.badgeRow}>
                                <Text style={[styles.badge, styles.paid]}>Paid</Text>
                                <Text style={[styles.badge, styles.stripe]}>
                                    {sponsor.payment_mode}
                                </Text>
                            </View>
                        </View>
                    </View>

                    {/* Vendor Details */}
                    <View style={styles.section}>
                        <Text style={styles.subtitle}>Vendor Details</Text>
                        <View style={styles.box}>
                            <Text>{sponsor.vendor_name}</Text>
                            <Text>{sponsor.vendor_email}</Text>
                            <Text>{sponsor.vendor_mobile}</Text>
                        </View>
                    </View>
                </View>

                {/* Table Summary */}
                <View style={styles.section}>
                    <Text style={styles.subtitle}>Payment Summary</Text>
                    <View style={styles.table}>
                        {/* Table Header */}
                        <View style={styles.tableRowHeader}>
                            <Text style={styles.colSL}>S.L</Text>
                            <Text style={styles.colSponsor}>SPONSOR</Text>
                            <Text style={styles.colStore}>STORE</Text>
                            <Text style={styles.colDays}>DAYS</Text>
                            <Text style={styles.colPrice}>PRICE</Text>
                            <Text style={styles.colStart}>START DATE</Text>
                            <Text style={styles.colEnd}>END DATE</Text>
                        </View>

                        {/* Table Row */}
                        <View style={styles.tableRow}>
                            <Text style={styles.colSL}>1</Text>
                            <Text style={styles.colSponsor}>{sponsor.vendor_name}</Text>
                            <Text style={styles.colStore}>{sponsor.service_name}</Text>
                            <Text style={styles.colDays}>{sponsor.days}</Text>
                            <Text style={styles.colPrice}>{sponsor.goal_price}</Text>
                            <Text style={styles.colStart}>{sponsor.start_date}</Text>
                            <Text style={styles.colEnd}>{sponsor.end_date}</Text>
                        </View>
                    </View>
                </View>
            </Page>
        </Document>
    );
};

export default InvoiceDocumentSponcer;
