import React, { useEffect, useState } from "react";
import Background from "../../assets/Images/installbgimage.png";
import Logo from "../../assets/Images/logo.png";
import LightVector from "../../assets/Images/LightVector.png";
import InfoCircle from "../../assets/Images/info.png";
import GreenTick from "../../assets/Images/cheack.png";
import LightStroke from "../../assets/Images/LightStroke.png";
import axios from "axios";
import { RxCross2 } from "react-icons/rx";
import { Link } from "react-router-dom";

type ExtensionsData = {
    required_php_version?: string,
    php_version_status?: boolean,
    all_valid?: boolean,
    extensions?: {
        bcmath?: boolean,
        openssl?: boolean,
        ctype?: boolean,
        pdo?: boolean,
        fileinfo?: boolean,
        tokenizer?: boolean,
        json?: boolean,
        xml?: boolean,
        mbstring?: boolean,
    },
};

const Page1: React.FC = () => {
    const [extensions, setExtensions] = useState<ExtensionsData | null>(null);

    useEffect(() => {
        const fetchAdminDetails = async () => {
            try {
                const response = await axios.get<ExtensionsData>(`${import.meta.env.VITE_API_URL}/check-extensions`);
                setExtensions(response.data);
            } catch (err) {
                console.error("Failed to fetch admin login details", err);
            }
        };

        fetchAdminDetails();
    }, []);

    const Extensions = extensions?.extensions;

    function handleSet() {
        sessionStorage.setItem("show_varification_steps", "true");
    }

    return (
        <div className="relative w-full h-screen">
            <img src={Background} alt="Background" className="object-cover w-full h-full" />

            <div className="absolute inset-0 flex flex-col">
                <div className="flex justify-center p-8  sm:justify-end xl:mr-[4rem]">
                    <div className="flex items-center gap-3">
                        <img src={Logo} alt="Logo" className=" w-[10rem]" />
                    </div>
                </div>

                <div className="justify-center">
                    <h2 className="text-[#000000] sm:text-4xl text-xl font-semibold font-poppins text-center">Nlytical App Software Installation</h2>
                    <p className="text-[#000000] font-poppins sm:text-base text-center pt-2">Please make sure the PHP extensions listed below are installed</p>
                </div>

                {/* Step Indicator */}
                <div className="flex justify-center py-3 sm:gap-3 place-items-center">
                    {["1", "2", "3", "4",].map((step, index) => (
                        <React.Fragment key={step}>
                            <button className={`rounded-full px-4 py-[7px] ${step === "1" ? "bggradient text-white" : "  text-[#000000]  bg-[#0046AE1F]"} font-poppins`}>{step}</button>
                            {index !== 3 && <img src={index === 0 ? LightVector : LightStroke} className="w-16" />}
                        </React.Fragment>
                    ))}
                </div>

                <div className="flex justify-center py-6 w-fit sm:w-full">
                    <div className="bg-[#FFFFFF] sm:w-[950px] w-fit rounded-md p-3" style={{ boxShadow: "8px 9px 55.9px 0px #00000033" }}>
                        <div className="justify-between sm:flex">
                            <h2 className="font-poppins text-[#000000] text-base flex flex-row">
                                Step 1 :
                                <div className="flex flex-col">
                                    <span className="font-poppins text-[#555555] text-base pl-1">Required PHP Extensions</span>
                                    <span className="hidden pl-1 text-sm text-red-500 sm:block xl:text-sm 2xl:text-sm font-poppins">Please make sure the PHP extensions listed below are installed</span>
                                </div>
                            </h2>
                            <span className="block text-sm text-red-500 sm:hidden xl:text-sm 2xl:text-sm font-poppins">Please make sure the PHP extensions listed below are installed</span>

                            <div className="flex gap-1 place-items-center">
                                <a target="_blank" rel="noopener noreferrer" href="https://document.snapta.online/" className="font-poppins text-[#435CFF] underline text-xs cursor-pointer">
                                    Read documentation
                                </a>
                                <img src={InfoCircle} className="w-3 h-3" />
                            </div>
                        </div>

                        <div className="sm:p-4" style={{ boxShadow: "2px 4px 14.4px 0px #0000000F" }}>
                            <h2 className="font-poppins text-[#000000A1] text-opacity-[63%] text-center pt-4 pb-4 font-semibold">Check & Verify File Permissions</h2>

                            <div className="overflow-x-auto">
                                <table className="min-w-full border border-collapse border-[#D3D3D37D]">
                                    <tbody>
                                        {/* Email Row */}
                                        <tr className="border   border-[#D3D3D37D]      ">
                                            <td className="px-4 py-2 sm:w-[25%] w-[10%] text-[#452B7A] text-center font-poppins border  bg-[#0046AE33] border-[#D3D3D37D]">Extension</td>
                                            <td className="px-4 py-2 sm:w-[25%] w-[10%] text-[#452B7A] bg-[#0046AE33] font-poppins text-center border border-[#D3D3D37D]">Status</td>
                                            <td className="px-4 py-2 sm:w-[25%] w-[10%] text-[#452B7A] bg-[#0046AE33] font-poppins text-center border border-[#D3D3D37D]">Extension</td>
                                            <td className="px-4 py-2 sm:w-[25%] w-[10%] text-[#452B7A] bg-[#0046AE33] font-poppins text-center border border-[#D3D3D37D]">Status</td>
                                        </tr>

                                        {/* Row 2 */}
                                        <tr className="border border-[#D3D3D37D]">
                                            <td className="px-4 py-2 w-[25%] text-center text-sm font-poppins border border-[#D3D3D37D]">PHP&gt;=8.1</td>
                                            <td className="px-4 py-2 w-[25%] place-items-center text-[#000000] font-poppins text-center border border-[#D3D3D37D]">
                                                {extensions?.required_php_version === "8.1" ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] font-poppins text-center border border-[#D3D3D37D]">PHP Version</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {extensions?.php_version_status === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                        </tr>

                                        {/* Row 3 */}
                                        <tr className="border border-[#D3D3D37D]">
                                            <td className="px-4 py-2 w-[25%] text-center font-poppins border text-sm border-[#D3D3D37D]">Bcmath</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {Extensions?.bcmath === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] font-poppins text-center border border-[#D3D3D37D]">Openssl</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {Extensions?.openssl === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                        </tr>

                                        {/* Row 4 */}
                                        <tr className="border border-[#D3D3D37D]">
                                            <td className="px-4 py-2 w-[25%] text-center font-poppins border text-sm border-[#D3D3D37D]">Ctype</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {Extensions?.ctype === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] font-poppins text-center border border-[#D3D3D37D]">Pdo</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {Extensions?.pdo === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                        </tr>

                                        {/* Row 5 */}
                                        <tr className="border border-[#D3D3D37D]">
                                            <td className="px-4 py-2 w-[25%] text-center font-poppins text-sm border border-[#D3D3D37D]">Fileinfo</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {Extensions?.fileinfo === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] font-poppins text-center border border-[#D3D3D37D]">Tokenizer</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {Extensions?.tokenizer === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}

                                                {/* <img src={Extensions?.tokenizer === true ? GreenTick : <RxCross2 className='text-red-500'/>} className='w-4 h-4'/> */}
                                            </td>
                                        </tr>

                                        {/* Row 6 */}
                                        <tr className="border border-[#D3D3D37D]">
                                            <td className="px-4 py-2 w-[25%] text-center text-sm font-poppins border border-[#D3D3D37D]">Json</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {/* <img src={Extensions?.json === true ? GreenTick : <RxCross2 className='text-red-500'/>} className='w-4 h-4'/> */}
                                                {Extensions?.json === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] font-poppins text-center border border-[#D3D3D37D]">Xml</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {Extensions?.xml === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                        </tr>

                                        {/* Row 7 */}
                                        <tr className="border font-poppins border-[#D3D3D37D]">
                                            <td className="px-4 py-2 w-[25%] text-center font-poppins border text-sm border-[#D3D3D37D]">Mbstring</td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">
                                                {Extensions?.mbstring === true ? <img src={GreenTick} className="w-4 h-4" /> : <RxCross2 className="text-red-500" />}
                                            </td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] font-poppins text-center border border-[#D3D3D37D]"></td>
                                            <td className="px-4 py-2 w-[25%] text-[#000000] place-items-center font-poppins text-center border border-[#D3D3D37D]">{/* <img src={GreenTick} className='w-4 h-4'/> */}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        {/* Next button */}
                        <div className="flex justify-center py-3">
                            <Link to="/nlytical-install-2">
                                <button
                                    className={`px-20 py-3 font-poppins font-medium text-white cursor-pointer rounded-xl ${extensions?.all_valid ? " bggradient" : " bg-[#0046AE99] cursor-not-allowed"}`}
                                    onClick={handleSet}
                                    disabled={!extensions?.all_valid}
                                >
                                    Next
                                </button>
                            </Link>
                        </div>
                    </div>
                </div>

                {/* Divider */}
                <div className="flex justify-center py-2">
                    <div className="bg-[#CCCCCC] h-[1.5px] rounded-lg w-[950px]"></div>
                </div>

                {/* Footer */}
                <div className="sm:flex justify-between w-full max-w-[970px] mx-auto px-4 pb-4 sm:pb-0">
                    <div className="flex items-center gap-2">
                        <img src={Logo} alt="Logo" className="w-[8rem] h-[2.7rem]" />
                    </div>
                    <p className="font-poppins text-[#535353] text-sm">
                        @2025 | All rights reserved by{" "}
                        <a className="text-[#2A2A2A] underline font-semibold cursor-pointer" href="https://primocys.com/" target="_blank" rel="noopener noreferrer">
                            Primocys
                        </a>
                        .
                    </p>
                </div>
            </div>
        </div>
    );
};

export default Page1;
