import { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import { Link, useNavigate } from "react-router-dom";
import Add from "../../assets/Images/add.png";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import useApiPost from "../../Hooks/PostData";
import notfound from "../../assets/Images/notfound.png";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import TableDateTimeDisplay from "../../Componets/TableComponets/TableDateTimeDisplay";
import toast from "react-hot-toast";
import Apimethod from "../../Hooks/Apimethod";
import { showModal } from "../../Appstore/Slice/ModalSlice";
import { reset } from "../../Appstore/Slice/toggleSlice";
import TableActionButtons from "../../Componets/TableComponets/TableActionButtons";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import Search from "../../assets/Images/search.png";
import LanguageTranslatePagination from "../../Componets/PaginationComponets/LanguageTranslatePagination";
import { setPaginationLanguageTransalateList } from "../../Appstore/Slice/PaginationSlice/LanguageTranslatePaginationSlice";
import SimpletextTableBodyReview from "../../Componets/TableComponets/SimpletextTableBodyReview";
import Block from "../../assets/Images/deleteicon.png";
import { clearCoverImage } from "../../Appstore/Slice/AddImageSlice";
import { resetall } from "../../Appstore/Slice/AddVendorSlice";
import edit from "../../assets/Images/edit.png"
import { setSlider } from "../../Appstore/Slice/sliderSlice";

function Slider() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const { data, loading, error, postData } = useApiPost();
    const [search, setSearch] = useState("");

    const pagination = useAppSelector(
        (state) => state.LanguageTranslatePaginationSlice
    );
    const { current_page, records_per_page } = pagination;

    const [toggleStates, setToggleStates] = useState<{ [key: number]: boolean }>(
        {}
    );


    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';

    // Fetch data
    useEffect(() => {
        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim(),
        };

        postData("/slider-list", params);
    }, [current_page, records_per_page, search]);

    const isaddgiftvalues = useAppSelector((state) => state.toggle.value);

    useEffect(() => {
        if (isaddgiftvalues) {
            postData("/slider-list", {});
        }
    }, [isaddgiftvalues]);

    useEffect(() => {
        if (data?.sliders) {
            const toggles = data.sliders.reduce((acc, gift) => {
                acc[gift.id] = gift.status;
                return acc;
            }, {} as { [key: number]: boolean });
            setToggleStates(toggles);
        }
    }, [data]);

    const dispatch = useAppDispatch();

    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationLanguageTransalateList(data?.Pagination));
        }
    }, [data, dispatch]);

    const { makeRequest } = Apimethod();

    const handleToggleStatus = async (giftId: number) => {

        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const newStatus = !toggleStates[giftId];
        try {
            await makeRequest(
                "/update-sliderstatus",
                {
                    id: giftId,
                    status: newStatus ? 1 : 0, // convert boolean to 1 or 0
                },
                "application/json",
                "POST"
            );
            setToggleStates((prev) => ({
                ...prev,
                [giftId]: newStatus,
            }));
            toast.success("Status changed successfully");
        } catch (err) {
            toast.error("Failed to update status");
        }
    };


    const handleBlock = (id: string) => {
       
        sessionStorage.setItem("SliderDeleteid", id)
        dispatch(showModal("DeleteSliderModal"))
        dispatch(reset())
    };



    const handalupdateslider = (gift: any) => {
       
        dispatch(setSlider(gift));
        dispatch(showModal("UpdateSliderModal"));
        dispatch(reset())
    }

    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">
                        Slider List
                    </h2>
                    <div className="relative">
                        <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
                            <img
                                src={Search}
                                alt="Search"
                                className="h-4 w-4 md:h-5 md:w-5"
                            />
                        </div>
                        <div className=" w-full">
                            <input
                                type="text"
                                placeholder="Search by Description..."
                                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "
                                onChange={(e) => setSearch(e.target.value)}
                                value={search}
                            />
                        </div>
                    </div>
                </div>

                <div className="flex items-center justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base  font-semibold">
                                Dashboard
                            </h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]"></div>
                        <h3 className="text-[#858585] font-poppins text-base">
                            Slider List
                        </h3>
                    </div>

                    <button
                        className="flex gap-1.5 mr-1 py-2 cursor-pointer place-items-center px-4 font-poppins font-medium text-white rounded-md bggradient"
                        onClick={() => {
                           
                            dispatch(showModal("AddSliderModal"));
                            dispatch(clearCoverImage());
                            dispatch(resetall());
                            dispatch(reset())
                        }}
                    >
                        <img src={Add} className="w-4 h-4" />
                        <p className="md:text-sm text-xs">Add Slider</p>
                    </button>
                </div>
                <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        <div className="flex px-4 py-3 text-left border-b w-full bg-headercolortable border-b-bordercolor sm:pl-8">
                            <div className="w-[5%]">
                                <WithoutSorttableHeader label="S.L" />
                            </div>
                            <div className="w-[23%]">
                                <WithoutSorttableHeader label="SLIDER" />
                            </div>
                            <div className="w-[32%]">
                                <WithoutSorttableHeader label="DESCRIPTION" />
                            </div>
                            <div className="w-[20%]">
                                <WithoutSorttableHeader label="CREATED DATE/TIME" />
                            </div>
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="STATUS" />
                            </div>
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="ACTIONS" />
                            </div>
                        </div>

                        <div className="relative">
                            {loading && (
                                <div className=" h-[400px] flex items-center justify-center  ">
                                    <AvatarWithSpinner />
                                </div>
                            )}

                            {!loading && data?.sliders?.length > 0
                                ? data.sliders.map((gift: any, index: number) => (
                                    <div
                                        key={gift.gift_id}
                                        className={`    ${index % 2 === 0
                                            ? "bg-white dark:bg-primary"
                                            : "bg-[#00162e0a] dark:bg-primary"
                                            } flex items-center px-4 py-3 border-b border-b-bordercolor sm:pl-8`}
                                    >
                                        <div className="w-[5%] text-sm text-textcolor font-poppins">
                                            {(current_page - 1) * records_per_page + index + 1}
                                        </div>
                                        <div className="  w-[23%] ">
                                            <div className=" w-[5.5rem]  h-[5.5rem]  rounded-l-full  cursor-pointer ">
                                                <img
                                                    src={gift?.image}
                                                    className="  w-full  h-full   rounded-full "
                                                />
                                            </div>
                                        </div>

                                        <div className="w-[32%] whitespace-pre-wrap break-words text-textcolor">
                                            <SimpletextTableBodyReview title={gift.description} />
                                        </div>

                                        <div className=" w-[20%]">
                                            <TableDateTimeDisplay dateString={gift.created_at} />
                                        </div>

                                        <div className=" w-[10%] ">
                                            <label className="flex items-center cursor-pointer select-none">
                                                <div className="relative">
                                                    <input
                                                        type="checkbox"
                                                        checked={toggleStates[gift.id] || false}
                                                        onChange={() => handleToggleStatus(gift.id)}
                                                        className="sr-only"
                                                    />
                                                    <div
                                                        className={`block h-6 w-10 rounded-full border transition duration-300 ${toggleStates[gift.id]
                                                            ? " border-toggalbtcolorborder bggradient"
                                                            : "bg-transparent  border  border-toggalbtcolorborder"
                                                            }`}
                                                    ></div>
                                                    <div
                                                        className={`absolute top-1 h-4 w-4 rounded-full transition duration-300 ${toggleStates[gift.id]
                                                            ? "right-1 bg-white"
                                                            : "left-1 bggradient"
                                                            }`}
                                                    ></div>
                                                </div>
                                            </label>
                                        </div>

                                        <div className=" w-[10%]  flex gap-2 ">
                                            <button className="py-[9px] px-[10px] bg-[#D0CCE1]/60 cursor-pointer rounded-full" onClick={() => handalupdateslider(gift)} >
                                                <img src={edit} alt="Edit" className="w-5 h-4" />
                                            </button>
                                            <TableActionButtons
                                                viewButtonColor="#CCE1CD"
                                                borderColor="#01D312"
                                                blockButtonIcon={Block}
                                                onBlockClick={() => handleBlock(gift.id)}

                                            />
                                        </div>
                                    </div>
                                ))
                                : !loading && (
                                    <div className="p-4 h-[38rem] flex justify-center items-center">
                                        <div className="w-full flex flex-col items-center h-full justify-center">
                                            <img
                                                src={notfound}
                                                alt="Not Found"
                                                className="w-1/2 max-h-[40vh] object-contain"
                                            />
                                            <h2 className="font-poppins text-lg text-textcolor  mt-4">
                                                No  Data Found
                                            </h2>
                                        </div>
                                    </div>
                                )}
                        </div>
                    </div>

                    <LanguageTranslatePagination />
                </div>
            </div>
        </div>
    );
}

export default Slider;
