import { useState, useEffect, useMemo, useCallback } from "react";
import toast from "react-hot-toast";
import useApiPost from "../../Hooks/PostData";
import { useAppDispatch } from "../../Hooks/Hooks";
import InputField from "../../Componets/InputField";
import { UseMailSetupsetting } from "../../Appstore/Api/UseMailSetupsetting";

function MailSetup() {
  const { data, isLoading, refetch } = UseMailSetupsetting();
  const { loading, error, postData } = useApiPost();
  const dispatch = useAppDispatch();


    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const [initialData, setInitialData] = useState(null);
  const [formData, setFormData] = useState({
    mail_mailer: "",
    mail_host: "",
    mail_port: "",
    mail_encryption: "",
    mail_username: "",
    mail_password: "",
    mail_from: ""
  });

  const [isEdited, setIsEdited] = useState(false);

  useEffect(() => {
    if (data?.data) {
      const {
        mail_mailer,
        mail_host,
        mail_port,
        mail_encryption,
        mail_username,
        mail_password,
        mail_from
      } = data.data;

      const defaultForm = {
        mail_mailer: mail_mailer || "",
        mail_host: mail_host || "",
        mail_port: mail_port || "",
        mail_encryption: mail_encryption || "",
        mail_username: mail_username || "",
        mail_password: mail_password || "",
        mail_from: mail_from || ""
      };

      setFormData(defaultForm);
      setInitialData(defaultForm);
    }
  }, [data]);

  const handleChange = useCallback((field: string, value: string) => {
    setFormData((prev) => ({ ...prev, [field]: value }));
    setIsEdited(true);
  }, []);

  const isFormEdited = useMemo(() => {
    if (!initialData) return false;

    return Object.keys(formData).some(
      (key) => formData[key] !== initialData[key]
    );
  }, [formData, initialData]);

  useEffect(() => {
    setIsEdited(isFormEdited);
  }, [isFormEdited]);

  const handleSubmit = async () => {

       if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
    if (!isEdited) return;

    const formPayload = new FormData();
    Object.entries(formData).forEach(([key, value]) => {
      formPayload.append(key, value);
    });

    try {
      await postData("/mail-setup", formPayload, "multipart/form-data");
      toast.success("Settings updated successfully!");
      setIsEdited(false);
      refetch();
    } catch (err) {
      toast.error(err?.response?.data?.message || "Failed to update settings");
    }
  };

  return (
    <>
      <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Mobile App URLs</h2>
      <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
        <div className="grid gap-4 pb-5 md:grid-cols-2">
          <InputField
            label="Mail Mailer"
            value={formData.mail_mailer}
            placeholder="Enter Mail Mailer"
            onChange={(e) => handleChange("mail_mailer", e.target.value)}
          />
          <InputField
            label="Mail Host"
            value={formData.mail_host}
            placeholder="Enter Mail Host"
            onChange={(e) => handleChange("mail_host", e.target.value)}
          />
          <InputField
            label="Mail Port"
            value={formData.mail_port}
            placeholder="Enter Mail Port"
            onChange={(e) => handleChange("mail_port", e.target.value)}
          />
          <InputField
            label="Mail Encryption"
            value={formData.mail_encryption}
            placeholder="Enter Mail Encryption"
            onChange={(e) => handleChange("mail_encryption", e.target.value)}
          />

          <InputField
            label=" Mail Username"
            value={formData.mail_username}
            placeholder="Enter Mail Username"
            onChange={(e) => handleChange("mail_username", e.target.value)}
          />


          <InputField
            label=" Mail Password"
            value={formData.mail_password}
            placeholder="Enter Mail Password"
            onChange={(e) => handleChange("mail_password", e.target.value)}
            type="password"
          />

          <InputField
            label="Mail from Address"
            value={formData.mail_from}
            placeholder="Enter Mail Username"
            onChange={(e) => handleChange("mail_from", e.target.value)}
          />


        </div>

        <div className="flex justify-center py-6 place-items-center">
          <button
            onClick={handleSubmit}
            disabled={!isEdited}
            className={`px-24 py-3 font-medium text-white   rounded-xl ${isEdited ? "bggradient cursor-pointer " : "bggradient opacity-50 cursor-not-allowed"
              }`}
          >
            {loading ? "Submitting..." : "Submit"}
          </button>
        </div>
      </div>
    </>
  );
}

export default MailSetup;
