import { useState, useEffect, useMemo, useCallback } from "react";
import toast from "react-hot-toast";
import useApiPost from "../../Hooks/PostData";
import { useAppDispatch } from "../../Hooks/Hooks";
import InputField from "../../Componets/InputField";
import { UsegetSocialSetting } from "../../Appstore/Api/UsegetSocialSetting";

function FirebaseSetup() {
  const { data, isLoading, refetch } = UsegetSocialSetting();
  const { loading, error, postData } = useApiPost();
  const dispatch = useAppDispatch();

  const [initialData, setInitialData] = useState(null);
  const [formData, setFormData] = useState({
    share_link: "",
    whatsapp_link: "",
    instagram_link: "",
    twitter_link: "",
    youtube_link: "",
    linkdln_link: "",
  });

  const [isEdited, setIsEdited] = useState(false);

  useEffect(() => {
    if (data?.data) {
      const {
        share_link,
        whatsapp_link,
        instagram_link,
        twitter_link,
        youtube_link,
        linkdln_link,
      } = data.data;

      const defaultForm = {
        share_link: share_link || "",
        whatsapp_link: whatsapp_link || "",
        instagram_link: instagram_link || "",
        twitter_link: twitter_link || "",
        youtube_link: youtube_link || "",
        linkdln_link: linkdln_link || "",
      };

      setFormData(defaultForm);
      setInitialData(defaultForm);
    }
  }, [data]);

  const handleChange = useCallback((field: string, value: string) => {
    setFormData((prev) => ({ ...prev, [field]: value }));
    setIsEdited(true);
  }, []);

  const isFormEdited = useMemo(() => {
    if (!initialData) return false;

    return Object.keys(formData).some(
      (key) => formData[key] !== initialData[key]
    );
  }, [formData, initialData]);

  useEffect(() => {
    setIsEdited(isFormEdited);
  }, [isFormEdited]);

  const handleSubmit = async () => {
    if (!isEdited) return;

    const formPayload = new FormData();
    Object.entries(formData).forEach(([key, value]) => {
      formPayload.append(key, value);
    });

    try {
      await postData("/social-media", formPayload, "multipart/form-data");
      toast.success("Settings updated successfully!");
      setIsEdited(false);
      refetch();
    } catch (err) {
      toast.error(err?.response?.data?.message || "Failed to update settings");
    }
  };

  return (
    <>
      <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Share Link</h2>
      <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
        <div className="grid gap-4 pb-5">
          <InputField
            label="Share Link"
            value={formData.share_link}
            placeholder="Enter Facebook URL"
            onChange={(e) => handleChange("share_link", e.target.value)}
          />





        </div>

        <div className="flex justify-center py-6 place-items-center">
          <button
            onClick={handleSubmit}
            disabled={!isEdited}
            className={`px-24 py-3 font-medium text-white rounded-xl cursor-pointer ${isEdited ? "bggradient" : "bggradient opacity-50 cursor-not-allowed"
              }`}
          >
            {loading ? "Submitting..." : "Submit"}
          </button>
        </div>
      </div>
    </>
  );
}

export default FirebaseSetup;  
