import { useState, useEffect, useMemo, useCallback } from "react";
import toast from "react-hot-toast";
import useApiPost from "../../Hooks/PostData";
import { useAppDispatch } from "../../Hooks/Hooks";
import InputField from "../../Componets/InputField";
import { UsegetSocialSetting } from "../../Appstore/Api/UsegetSocialSetting";

function Bucket() {
  const { data, isLoading, refetch } = UsegetSocialSetting();
  const { loading, error, postData } = useApiPost();
  const dispatch = useAppDispatch();
    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';

  const [initialData, setInitialData] = useState(null);
  const [formData, setFormData] = useState({
    facebook_link: "",
    whatsapp_link: "",
    instagram_link: "",
    twitter_link: "",
    youtube_link: "",
    linkdln_link: "",
  });

  const [isEdited, setIsEdited] = useState(false);

  useEffect(() => {
    if (data?.data) {
      const {
        facebook_link,
        whatsapp_link,
        instagram_link,
        twitter_link,
        youtube_link,
        linkdln_link,
      } = data.data;

      const defaultForm = {
        facebook_link: facebook_link || "",
        whatsapp_link: whatsapp_link || "",
        instagram_link: instagram_link || "",
        twitter_link: twitter_link || "",
        youtube_link: youtube_link || "",
        linkdln_link: linkdln_link || "",
      };

      setFormData(defaultForm);
      setInitialData(defaultForm);
    }
  }, [data]);

  const handleChange = useCallback((field: string, value: string) => {
    setFormData((prev) => ({ ...prev, [field]: value }));
    setIsEdited(true);
  }, []);

  const isFormEdited = useMemo(() => {
    if (!initialData) return false;

    return Object.keys(formData).some(
      (key) => formData[key] !== initialData[key]
    );
  }, [formData, initialData]);

  useEffect(() => {
    setIsEdited(isFormEdited);
  }, [isFormEdited]);

  const handleSubmit = async () => {

       if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
    if (!isEdited) return;

    const formPayload = new FormData();
    Object.entries(formData).forEach(([key, value]) => {
      formPayload.append(key, value);
    });

    try {
      await postData("/social-media", formPayload, "multipart/form-data");
      toast.success("Settings updated successfully!");
      setIsEdited(false);
      refetch();
    } catch (err) {
      toast.error(err?.response?.data?.message || "Failed to update settings");
    }
  };

  return (
    <>
      <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Social Media</h2>
      <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
        <div className="grid gap-4 pb-5 md:grid-cols-2">
          <InputField
            label="Facebook URL"
            value={formData.facebook_link}
            placeholder="Enter Facebook URL"
            onChange={(e) => handleChange("facebook_link", e.target.value)}
          />
          <InputField
            label="Instagram URL"
            value={formData.whatsapp_link}
            placeholder="Enter Instagram URL"
            onChange={(e) => handleChange("whatsapp_link", e.target.value)}
          />
          <InputField
            label="Twitter URL"
            value={formData.instagram_link}
            placeholder="Enter Twitter URL"
            onChange={(e) => handleChange("instagram_link", e.target.value)}
          />
          <InputField
            label="Youtube URL"
            value={formData.twitter_link}
            placeholder="Enter Youtube URL"
            onChange={(e) => handleChange("twitter_link", e.target.value)}
          />

          <InputField
            label=" Linkdln URL"
            value={formData.youtube_link}
            placeholder="Enter Linkdln URL"
            onChange={(e) => handleChange("youtube_link", e.target.value)}
          />


          <InputField
            label=" Whatsapp URL"
            value={formData.linkdln_link}
            placeholder="Enter Whatsapp URL"
            onChange={(e) => handleChange("linkdln_link", e.target.value)}
          />




        </div>

        <div className="flex justify-center py-6 place-items-center">
          <button
            onClick={handleSubmit}
            disabled={!isEdited}
            className={`px-24 py-3 font-medium text-white rounded-xl ${isEdited ? "bggradient  cursor-pointer"  : "bggradient opacity-50 cursor-not-allowed"
              }`}
          >
            {loading ? "Submitting..." : "Submit"}
          </button>
        </div>
      </div>
    </>
  );
}

export default Bucket;  
