"use client";
import { useDispatch } from "react-redux";
import { useEffect, useState } from "react";
import { MdOutlineCheck, MdOutlineChevronRight } from "react-icons/md";
import { UseGetStoreList } from "../../Appstore/Api/UseGetStoreList";
import { useAppSelector } from "../../Hooks/Hooks";
import {
    toggleUpdateselectedstoreid,
    setMultipleSelectedStores,
} from "../../Appstore/Slice/UpdateSelectedStoreIDSlice";

const UpdateServiceStore = () => {
    const dispatch = useDispatch();
    const { data, isLoading } = UseGetStoreList();

    const service_id = useAppSelector((state) => state.storeSliceUpdate.service_id);
    const selectedCategories = useAppSelector((state) => state.UpdateSelectedStoreIDSlice.selectedCategories);



    console.log("selectedCategoriesselectedCategoriesselectedCategoriesselectedCategories" ,selectedCategories)


    const [searchValue, setSearchValue] = useState<string>("");
    const [showDropdown, setShowDropdown] = useState<boolean>(false);
    const [rotate, setRotate] = useState<boolean>(false);

    const categories = data?.ServiceList.map((item) => ({
        id: item.id,
        service_name: item.service_name,
    })) || [];

    // Pre-select multiple stores from `service_id` (comma-separated string)
    useEffect(() => {
        if (service_id && categories.length > 0 && selectedCategories.length === 0) {
            const idsArray = String(service_id).split(",").map(id => Number(id.trim()));
            const matched = categories.filter(cat => idsArray.includes(cat.id));
            if (matched.length > 0) {
                dispatch(setMultipleSelectedStores(matched));
            }
        }
    }, [service_id, categories, selectedCategories.length, dispatch]);

    const handleSelectCategory = (category: { id: number; service_name: string }) => {
        dispatch(toggleUpdateselectedstoreid(category));
        setShowDropdown(false);
        setRotate(false);
    };

    const handleFocus = () => {
        setShowDropdown(true);
        setRotate(true);
    };

    const handleBlur = () => {
        setTimeout(() => {
            setShowDropdown(false);
            setRotate(false);
        }, 100);
    };

    const handleToggle = () => {
        setShowDropdown((prev) => !prev);
        setRotate((prev) => !prev);
    };

    const isSelected = (id: number) => selectedCategories.some((cat) => cat.id === id);

    const filteredCategories = categories.filter((cat) =>
        cat.service_name.toLowerCase().includes(searchValue.toLowerCase())
    );

    return (
        <div className="w-full flex flex-col relative h-full">
            <label htmlFor="category" className="font-poppins text-sm font-medium text-textcolor">
                Store<span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative mt-1 flex items-center cursor-pointer">
                <input
                    type="text"
                    id="category"
                    name="category"
                    autoComplete="off"
                    spellCheck="false"
                    className="w-full rounded-lg border border-bordercolor cursor-pointer focus:border-toggalbtcolorborder text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
                    placeholder="Search or select category"
                    value={searchValue}
                    onFocus={handleFocus}
                    onBlur={handleBlur}
                    onChange={(e) => setSearchValue(e.target.value)}
                />
                <div
                    className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
                    onClick={handleToggle}
                >
                    <MdOutlineChevronRight className="text-xl" />
                </div>
            </div>

            {selectedCategories.length > 0 && (
                <div className="flex flex-wrap mt-2 gap-2">
                    {selectedCategories.map((cat) => (
                        <span key={cat.id} className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins">
                            {cat.service_name}
                            <button
                                className="ml-2 text-red-500 hover:text-red-700"
                                onClick={() => handleSelectCategory(cat)} // toggle logic will remove it
                            >
                                ×
                            </button>
                        </span>
                    ))}
                </div>
            )}

            {showDropdown && (
                <ul className="absolute top-[5rem] left-0 w-full bg-primary text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
                    {isLoading ? (
                        <li className="px-4 py-2 font-poppins text-center text-gray-500">Loading stores...</li>
                    ) : filteredCategories.length > 0 ? (
                        filteredCategories.map((cat) => (
                            <li
                                key={cat.id}
                                className="px-4 py-2 cursor-pointer font-poppins hover:bg-gray-200 text-textcolor flex justify-between items-center"
                                onMouseDown={() => handleSelectCategory(cat)}
                            >
                                {cat.service_name}
                                {isSelected(cat.id) && (
                                    <MdOutlineCheck className="text-[#6565657a] text-lg" />
                                )}
                            </li>
                        ))
                    ) : (
                        <li className="px-4 py-2 font-poppins text-center text-gray-500">No store found</li>
                    )}
                </ul>
            )}
        </div>
    );
};

export default UpdateServiceStore;
