import React, { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import { Link } from "react-router-dom";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import Search from "../../assets/Images/search.png";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import useApiPost from "../../Hooks/PostData";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import { setPaginationRechargelList } from "../../Appstore/Slice/PaginationSlice/RechargePaginationSlice";
import RechargePagination from "../../Componets/PaginationComponets/RechargePagination";
import SimpletextTableBody from "../../Componets/TableComponets/SimpletextTableBody";
import notfound from "../../assets/Images/notfound.png"
import Loader from "../../assets/Images/Loader.gif"

function Recharge() {
    const dispatch = useAppDispatch();
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const { data, loading, postData } = useApiPost();
    const pagination = useAppSelector((state) => state.RechargePaginationSlice);
    const { current_page, records_per_page } = pagination;

    useEffect(() => {
        const formData = new FormData();
        formData.append("transaction_table", "money");
        formData.append("transaction_type", "recharge")
        formData.append("page", current_page.toString());
        formData.append("pageSize", records_per_page.toString());
        postData("/admin/transaction-history", formData);
    }, [current_page, records_per_page]);



    const TotalValues = data?.data?.Records;

    // Set Recharge List
    useEffect(() => {

        if (data?.data?.Pagination) {
            dispatch(setPaginationRechargelList(data.data.Pagination));
        }
    }, [data, dispatch]);

    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />

            <div className="px-4 pb-10 xl:px-6">
                {/* Header */}
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="pt-3 text-xl font-semibold text-textcolor font-poppins">
                        Recharge List
                    </h2>

                    {/* <div className="relative">
                        <div className="absolute left-2 top-1/2 -translate-y-1/2 p-2">
                            <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
                        </div>
                        <input
                            type="text"
                            placeholder="Search Recharge..."
                            className="w-[180px] md:w-[250px] pl-10 py-2 text-sm border border-bordercolor border-opacity-10 
                rounded-lg  bg-inputbgcolor placeholder:text-paginationtextcolor   text-textcolor                placeholder:dark:text-tableDarkLarge focus:outline-none focus:ring-1 focus:ring-gray-600"
                        />
                    </div> */}
                </div>

                {/* Breadcrumb */}
                <div className="mb-4 flex items-center gap-2">
                    <Link to="/dashboard">
                        <h3 className="text-base font-semibold text-[#3A3A3A]  font-poppins">
                            Dashboard
                        </h3>
                    </Link>
                    <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
                    <h3 className="text-base text-[#858585] font-poppins">Recharge List</h3>
                </div>

                {/* Table */}
                <div className="mt-6 w-full overflow-x-auto rounded-lg border border-bordercolor">
                    <div className="min-w-[1200px]">
                        {/* Table Header */}
                        <div className="flex  bg-headercolortable px-4 py-3 text-left font-medium border-b border-bordercolor sm:pl-8">
                            <div className="w-[10%]"><WithoutSorttableHeader label="S.L" /></div>
                            <div className="w-[20%]"><WithoutSorttableHeader label="PRICE / COIN" /></div>
                            <div className="w-[20%]"><WithoutSorttableHeader label="PAST COIN" /></div>
                            <div className="w-[20%]"><WithoutSorttableHeader label="PAYMENT METHOD" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="STATUS" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="AMOUNT" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="TYPES" /></div>
                        </div>
                        {loading ? (
                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <div className="text-center">

                                    <img src={Loader} alt="loader" height={50} width={50} />
                                </div>
                            </div>
                        ) : TotalValues?.length > 0 ? (
                            TotalValues?.map((user: any, index: number) => (
                                <div
                                    key={user.transaction_id}
                                    className={`flex items-center px-4 py-3 border-b border-b-bordercolor    ${index % 2 === 0 ? 'bg-white dark:bg-primary' : 'bg-[#00162e0a] dark:bg-primary'
                                        }  sm:pl-8`}
                                >
                                    <div className="w-[10%] text-sm font-poppins text-textcolor">
                                        {(current_page - 1) * records_per_page + index + 1}
                                    </div>


                                    <div className="w-[20%] ">
                                        <SimpletextTableBody title={user.acutal_money} />
                                    </div>
                                    <div className="w-[20%] ">
                                        <SimpletextTableBody title={user.past_coin} />
                                    </div>
                                    <div className="w-[20%] ">
                                        <SimpletextTableBody title={user.payment_method} />
                                    </div>

                                    <div className="w-[10%] ">

                                        <SimpletextTableBody title={user.success} />


                                    </div>
                                    <div className="w-[10%] ">

                                        <SimpletextTableBody title={user.coin_price} />


                                    </div>
                                    <div className="w-[10%] ">

                                        <SimpletextTableBody title={user.transaction_type} />


                                    </div>

                                </div>
                            ))
                        ) : (
                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <div className="w-full flex flex-col items-center h-full justify-center">
                                    <img
                                        src={notfound}
                                        alt="Not Found"
                                        className="w-1/2 max-h-[40vh] object-contain"
                                    />
                                    <h2 className="font-poppins text-lg text-textcolor  mt-4">
                                        Don't have any data to show
                                    </h2>
                                </div>
                            </div>
                        )}

                    </div>
                    <RechargePagination />
                </div>
            </div>
        </div>
    );
}

export default Recharge;
