import toast from "react-hot-toast";
import { useAppSelector } from "../../../Hooks/Hooks";
import useApiPost from "../../../Hooks/PostData";
import SelectedStore from "./SelectedStore";
import { useGetDataWithToken } from "../../../Appstore/Api/UsegetRefundpolicy";
import InputField from "../../../Componets/InputField";
import { useCallback, useEffect, useState } from "react";
import ToggleSwitchSettingLogin from "../../../Componets/ToggleSwitchSettingLogin";
import Apimethod from "../../../Hooks/Apimethod";

function SponsorStoresCard() {
    const { loading, postData } = useApiPost();

    const selectedCategories = useAppSelector((state) => state.CategorySelectedIDandValuesFrontEndStorelist.selectedCategories);


    console.log("selectedCategories" ,selectedCategories)


    const { data, isLoading, refetch } = useGetDataWithToken("/index-sponserstore", ["index-sponserstore"]);

        const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';




    const [formData, setFormData] = useState({
        title: "",
        subtext: "",
    });


    useEffect(() => {
        if (data?.sponser_store[0]) {
            const { title, subtext } = data.sponser_store[0];
            const defaultForm = {
                title: title || "",
                subtext: subtext || ""

            };
            setFormData(defaultForm);
        }
    }, [data]);

    const handleChange = useCallback((field: string, value: string) => {
        setFormData((prev) => ({ ...prev, [field]: value }));
    }, []);



    const handleSubmit = async () => {

        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const categoryIds = selectedCategories.map((cat) => cat.id).join(",");

        const formPayload = new FormData();
        formPayload.append("service_id", categoryIds);
        formPayload.append("title", formData.title)
        formPayload.append("subtext", formData.subtext)

        try {
            await postData("/index-sponserstore", formPayload, "multipart/form-data");
            toast.success("Settings updated successfully!");
        } catch (error) {
            console.error("Failed to update categories:", error);
        }
    };







    const { makeRequest } = Apimethod()

    const [localStatus, setLocalStatus] = useState<number | null>(null);

    useEffect(() => {
        if (data?.sponser_store[0]?.status !== undefined) {
            setLocalStatus(data?.sponser_store[0].status);
        }
    }, [data]);


    const handleStatusToggle = useCallback(async () => {
        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const currentStatus = localStatus === 1 ? 1 : 0;
        const newStatus = currentStatus === 1 ? 0 : 1;

        setLocalStatus(newStatus); // Instantly update toggle status on UI

        try {
            const response = await makeRequest(
                '/update-frontedstatus',
                {
                    status: newStatus,
                    id: data?.sponser_store[0]?.main_id || "",
                },
                'application/json',
                'POST'
            );

            toast.success(`Status updated to ${newStatus === 1 ? 'Enabled' : 'Disabled'}`);
            refetch(); // Refresh backend data
        } catch (error) {
            toast.error("Failed to update status.");
            setLocalStatus(currentStatus); // Revert on error
        }
    }, [makeRequest, data, localStatus]);


    return (
        <>

           <div className=" w-full  flex justify-center  items-center    mb-4">

                <ToggleSwitchSettingLogin
                    label="Enable"
                    enabled={localStatus === 1}
                    loading={isLoading}
                    onChange={handleStatusToggle}
                />
            </div>
            <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Sponsor Stores</h2>
            <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
                <div className="grid gap-4 pb-5">


                    <InputField
                        label="Title"
                        value={formData.title}
                        placeholder="Enter title"
                        onChange={(e) => handleChange("title", e.target.value)}
                    />
                    <InputField
                        label="Subtext"
                        value={formData.subtext}
                        placeholder="Enter subtext"
                        onChange={(e) => handleChange("subtext", e.target.value)}
                    />

                    <SelectedStore />
                </div>
                <div className="flex justify-center py-6 place-items-center">
                    <button
                        onClick={handleSubmit}
                        className={`px-24 py-3 font-medium text-white rounded-xl  cursor-pointer bggradient 
              `}
                    >
                        {loading ? "Submitting..." : "Submit"}
                    </button>
                </div>
            </div>


         
        </>
    );
}

export default SponsorStoresCard;
