
import { useCallback, useEffect, useState } from "react";
import { useGetDataWithToken } from "../../../Appstore/Api/UsegetRefundpolicy";
import ToggleSwitchSettingLogin from "../../../Componets/ToggleSwitchSettingLogin";
import Apimethod from "../../../Hooks/Apimethod";
import Card1 from "./Card1";
import Card2 from "./Card2";
import Card3 from "./Card3";
import Card4 from "./Card4";
import toast from "react-hot-toast";

function SponsorStores() {



      const { data:updatethedata, isLoading, error, refetch } = useGetDataWithToken("/indexcard1-update", ["indexcard1-update"]);
  
    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  console.log("Category Data: monuwwww", updatethedata?.data);


  const { makeRequest } = Apimethod()

  const [localStatus, setLocalStatus] = useState<number | null>(null);

  useEffect(() => {
    if (updatethedata?.data?.status !== undefined) {
      setLocalStatus(updatethedata?.data.status);
    }
  }, [updatethedata]);


  const handleStatusToggle = useCallback(async () => {

    if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
    const currentStatus = localStatus === 1 ? 1 : 0;
    const newStatus = currentStatus === 1 ? 0 : 1;

    setLocalStatus(newStatus); // Instantly update toggle status on UI

    try {
      const response = await makeRequest(
        '/update-frontedstatus',
        {
          status: newStatus,
          id: updatethedata?.data?.main_id || "",
        },
        'application/json',
        'POST'
      );

      toast.success(`Status updated to ${newStatus === 1 ? 'Enabled' : 'Disabled'}`);
      refetch(); // Refresh backend data
    } catch (error) {
      toast.error("Failed to update status.");
      setLocalStatus(currentStatus); // Revert on error
    }
  }, [makeRequest, updatethedata, localStatus]);


  return (
    <>

 <div className=" w-full  flex justify-center  items-center    mb-4">

          <ToggleSwitchSettingLogin
            label="Enable"
            enabled={localStatus === 1}
            loading={isLoading}
            onChange={handleStatusToggle}
          />
        </div>

      <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4"> Card</h2>
      <div className=" bg-primary rounded-lg  mt-5 md:mt-0">
        <div className="   w-full  grid  xl:grid-cols-2   gap-4 ">
          <Card1 />
          <Card2 />
          <Card3 />
          <Card4 />



        </div>

       
      </div>
    </>
  );
}

export default SponsorStores;
