import React, { useCallback, useEffect, useState } from 'react'
import { useGetDataWithToken } from '../../../Appstore/Api/UsegetRefundpolicy';
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import InputField from '../../../Componets/InputField';
import IMageCard1 from './IMageCard1';
import useApiPost from '../../../Hooks/PostData';
import toast from 'react-hot-toast';
import IMageCard2 from './IMageCard2';
import { setIndexCardData3 } from '../../../Appstore/Slice/indexCardSlice3';
import CategoryListFrontendCard3 from './CategoryListFrontendCard3';
import IMageCard3 from './IMageCard3';

function Card3() {

  const { data, isLoading, error, refetch } = useGetDataWithToken("/indexcard3-update", ["indexcard3-update"]);
    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const { postData, loading } = useApiPost()


  const dispatch = useAppDispatch()

  const selectedCategory = useAppSelector(
    (state) => state.CategorySelectedIDandValuesUpdateFronentCard3.selectedCategory
  );


  const image = useAppSelector((state) => state.UpdateCategoryImageSliceFrontend3.cover_image)

  useEffect(() => {
    if (data?.data) {
      dispatch(setIndexCardData3(data.data));
    }
  }, [data, dispatch]);



  const indexCard = useAppSelector((state) => state.indexCardSlice2.image)

  console.log(" my slectted alues in slice", indexCard)

  const [formData, setFormData] = useState({
    title: "",
  });


  useEffect(() => {
    if (data?.data) {
      const { title } = data.data;
      const defaultForm = {
        title: title || "",

      };
      setFormData(defaultForm);
    }
  }, [data]);


  const handleChange = useCallback((field: string, value: string) => {
    setFormData((prev) => ({ ...prev, [field]: value }));
  }, []);



  const handleSubmit = async () => {
if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
    const formPayload = new FormData();
    Object.entries(formData).forEach(([key, value]) => {
      formPayload.append(key, value);
    });

    if (image) {
      formPayload.append("image", image[0]);
    }

    if (selectedCategory) {
      formPayload.append("category_id", selectedCategory.id)
    }
    formPayload.append("title", formData.title)
    try {
      await postData("/indexcard3-update", formPayload, "multipart/form-data");
      toast.success("Settings updated successfully!");
      refetch();
    } catch (err) {
      toast.error(err?.response?.data?.message || "Failed to update settings");
    }
  };




  return (
    <div className=' w-full  h-fit flex flex-col  gap-4 rounded-md  p-4 shadow-lg border border-bordercolor '>
      {/*  card 1  values  */}

      <h3 className=' font-poppins  font-normal pb-4   text-textcolor  text-lg'> CARD 3</h3>
      <CategoryListFrontendCard3/>
      <InputField
        label="Title"
        value={formData.title}
        placeholder="Enter title"
        onChange={(e) => handleChange("title", e.target.value)}
      />
      <IMageCard3/>

      <div className="flex justify-center py-6 place-items-center">
        <button
          className={`px-24 py-3 font-medium cursor-pointer text-white rounded-xl bggradient`}
          onClick={handleSubmit}

        >
          {loading ? "Submitting..." : "Submit"}
        </button>
      </div>
    </div>
  )
}

export default Card3
