"use client";
import { useCallback, useEffect, useState } from "react";
import { useDispatch } from "react-redux";
import { MdOutlineCheck, MdOutlineChevronRight } from "react-icons/md";
import { useAppSelector } from "../../../Hooks/Hooks";
import { useGetGiftCategoryValues } from "../../../Appstore/Api/Gift/UsegetGiftCategoryValues";
import { useGetDataWithToken } from "../../../Appstore/Api/UsegetRefundpolicy";
import {
    toggleCategorySelectionFrontEnd,
    clearAllSelectedCategories,
} from "../../../Appstore/Slice/FrontEdnSlicevaluesStore";
import ToggleSwitchSettingLogin from "../../../Componets/ToggleSwitchSettingLogin";
import toast from "react-hot-toast";
import Apimethod from "../../../Hooks/Apimethod";

interface CategoryDropdownProps {
    required?: boolean;
}

const FrontEndCategory: React.FC<CategoryDropdownProps> = () => {
    const dispatch = useDispatch();
    const { data: categoryData, isLoading } = useGetGiftCategoryValues();
    const { data: updatethedata, refetch } = useGetDataWithToken(
        "/indexcategory-update",
        ["indexcategory-update"]
    );





    const selectedCategories = useAppSelector(
        (state) => state.FrontEdnSlicevaluesStore.selectedCategories
    );

    const [searchValue, setSearchValue] = useState("");
    const [showDropdown, setShowDropdown] = useState(false);
    const [rotate, setRotate] = useState(false);

    // Prepare categories from API
    const categories =
        categoryData?.data.map((item: any) => ({
            id: item.id,
            category_name: item.category_name,
        })) || [];

    // Inject default categories from /indexcategory-update into Redux
    useEffect(() => {
        if (updatethedata?.categories && Array.isArray(updatethedata.categories)) {
            const defaultCategories = updatethedata.categories.map((cat: any) => ({
                id: cat.id,
                category_name: cat.name,
            }));

            // Clear previous and dispatch all new ones
            dispatch(clearAllSelectedCategories());
            defaultCategories.forEach((cat: any) =>
                dispatch(toggleCategorySelectionFrontEnd(cat))
            );
        }
    }, [updatethedata, dispatch]);

    const handleSelectCategory = (categoryName: string, categoryId: number) => {
        dispatch(toggleCategorySelectionFrontEnd({ category_name: categoryName, id: categoryId }));
        setShowDropdown(false);
        setRotate(false);
        setSearchValue(""); // Optional: clear search
    };

    const handleFocus = () => {
        setShowDropdown(true);
        setRotate(true);
    };

    const handleBlur = () => {
        setTimeout(() => {
            setShowDropdown(false);
            setRotate(false);
        }, 100);
    };

    const handleToggle = () => {
        setShowDropdown((prev) => !prev);
        setRotate((prev) => !prev);
    };

    const isSelected = (id: number) =>
        selectedCategories?.some((cat: any) => cat.id === id);

    const filteredCategories = categories.filter((cat) =>
        cat.category_name.toLowerCase().includes(searchValue.toLowerCase())
    );




    console.log("Category Data: monu", updatethedata?.categories[0]?.main_id);





    return (
        <>
            


            <div className=" w-full  flex flex-col   justify-between   gap-y-4">
                <div className="w-full flex flex-col relative h-full">
                    <label
                        htmlFor="category"
                        className="font-poppins text-sm font-normal text-textcolor"
                    >
                        Category
                        <span className="text-[#F21818] pl-[1px]">*</span>
                    </label>

                    <div className="relative mt-2 flex items-center cursor-pointer">
                        <input
                            type="text"
                            id="category"
                            name="category"
                            autoComplete="off"
                            spellCheck="false"
                            className="w-full rounded-lg border border-bordercolor text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:font-gilroy_regular placeholder:text-sm placeholder:text-textcolor placeholder:opacity-50 focus:outline-none focus:ring-1 focus:ring-header"
                            placeholder="Search or select category"
                            value={searchValue}
                            onFocus={handleFocus}
                            onBlur={handleBlur}
                            onChange={(e) => setSearchValue(e.target.value)}
                        />
                        <div
                            className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
                            onClick={handleToggle}
                        >
                            <MdOutlineChevronRight className="text-xl" />
                        </div>
                    </div>

                    {/* Show selected categories as tags */}
                    {selectedCategories?.length > 0 && (
                        <div className="flex flex-wrap mt-2 gap-2">
                            {selectedCategories.map((cat: any) => (
                                <span
                                    key={cat.id}
                                    className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins"
                                >
                                    {cat.category_name}
                                    <button
                                        className="ml-2 text-red-500 hover:text-red-700"
                                        onClick={() =>
                                            dispatch(toggleCategorySelectionFrontEnd({ id: cat.id, category_name: cat.category_name }))
                                        }
                                    >
                                        ×
                                    </button>
                                </span>
                            ))}
                        </div>
                    )}

                    {/* Dropdown list */}
                    {showDropdown && (
                        <ul className="absolute top-[5.9rem] left-0 w-full bg-primary text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
                            {isLoading ? (
                                <li className="px-4 py-2 font-poppins text-center text-gray-500">
                                    Loading categories...
                                </li>
                            ) : filteredCategories.length > 0 ? (
                                filteredCategories.map((cat) => (
                                    <li
                                        key={cat.id}
                                        className="px-4 py-2 cursor-pointer font-poppins hover:bg-gray-200 text-textcolor flex justify-between items-center"
                                        onMouseDown={() => handleSelectCategory(cat.category_name, cat.id)}
                                    >
                                        {cat.category_name}
                                        {isSelected(cat.id) && (
                                            <MdOutlineCheck className="text-[#6565657a] text-lg" />
                                        )}
                                    </li>
                                ))
                            ) : (
                                <li className="px-4 py-2 font-poppins text-center text-gray-500">
                                    No categories found
                                </li>
                            )}
                        </ul>
                    )}
                </div>





            </div>
        </>
    );
};

export default FrontEndCategory;
