import React from 'react';
import {
  PieChart,
  Pie,
  Cell,
  ResponsiveContainer,
  Tooltip,
} from 'recharts';
import { UsegetDashboardData } from '../../Appstore/Api/UsegetDashboardData';
import AvatarWithSpinner from '../../Componets/LoadingComponest';

const COLORS = [
  '#0088FE', '#00C49F', '#FFBB28', '#FF8042',
  '#D77960', '#6956E5', '#E6B47B', '#A28DFF',
  '#FF6699', '#3399FF', '#FF9966', '#66CC99',
  '#7B68EE', '#DC143C', '#20B2AA', '#9370DB',
];

const RADIAN = Math.PI / 180;

const renderCustomizedLabel = ({
  cx, cy, midAngle, innerRadius, outerRadius, percent,
}: any) => {
  const radius = innerRadius + (outerRadius - innerRadius) * 0.5;
  const x = cx + radius * Math.cos(-midAngle * RADIAN);
  const y = cy + radius * Math.sin(-midAngle * RADIAN);
  const percentVal = (percent * 100).toFixed(0);

  return (
    <text
      x={x}
      y={y}
      fill="white"
      textAnchor={x > cx ? 'start' : 'end'}
      dominantBaseline="central"
      fontSize={11}
    >
      {percentVal > 0 ? `${percentVal}%` : ''}
    </text>
  );
};

const CustomTooltip = ({ active, payload }: any) => {
  if (active && payload && payload.length) {
    const item = payload[0].payload;
    return (
      <div className="bg-white p-2 border rounded shadow text-sm">
        <p><strong>{item.name}</strong></p>
        <p>Total Services: {item.value}</p>
        <p>Percentage: {item.percentage_tag}</p>
      </div>
    );
  }
  return null;
};

const LoginType = () => {
  const { data, isLoading } = UsegetDashboardData();
  const categories = data?.data?.categories || [];

  const pieData = categories
    .filter((item) => item.total_services > 0)
    .map((item) => ({
      name: item.category_name,
      value: item.total_services,
      percentage_tag: item.percentage_tag,
    }));

  if (isLoading) return <div className="h-[400px]  w-full  md:max-w-[540px] ml-[5rem] flex items-center justify-center">
    <AvatarWithSpinner />
  </div>;;

  return (
    <div className="w-full border  p-2  border-bordercolor rounded-lg   xl:max-w-[540px]  flex flex-col gap-4 items-start">

      <h2 className="text-textcolor font-poppins text-base font-semibold ">
        Categories
      </h2>
      {/* Pie Chart */}
      <div className="w-full aspect-[2/1]"> {/* 2:1 aspect ratio for better responsiveness */}
        <ResponsiveContainer width="100%" height="100%">
          <PieChart>
            <Pie
              data={pieData}
              cx="50%"
              cy="50%"
              labelLine={false}
              label={renderCustomizedLabel}
              outerRadius="80%"
              dataKey="value"
            >
              {pieData.map((entry, index) => (
                <Cell
                  key={`cell-${index}`}
                  fill={COLORS[index % COLORS.length]}
                />
              ))}
            </Pie>
            <Tooltip content={<CustomTooltip />} />
          </PieChart>
        </ResponsiveContainer>
      </div>


      {/* Legend */}
      <div className="w-full   max-h-[230px] overflow-auto grid grid-cols-2 sm:grid-cols-3 gap-2 text-sm pr-2">
        {pieData.map((entry, index) => (
          <div key={index} className="flex items-center gap-2">
            <span
              className="inline-block w-3 h-3 rounded-full"
              style={{ backgroundColor: COLORS[index % COLORS.length] }}
            />
            <span className="break-words  text-textcolor ">{entry.name} ({entry.value})</span>
          </div>
        ))}
      </div>

    </div>
  );
};

export default LoginType;
