import React from 'react'
import { Link, useNavigate } from 'react-router-dom'
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader'
import useApiPost from '../../Hooks/PostData'
import { UsegetDashboardData } from '../../Appstore/Api/UsegetDashboardData'
import notfound from "../../assets/Images/notfound.png"
import TableActionButtons from '../../Componets/TableComponets/TableActionButtons'
import AvatarWithSpinner from '../../Componets/LoadingComponest'
import TableUserInfo from '../../Componets/TableComponets/TableUserInfo'
import SimpletextTableBody from '../../Componets/TableComponets/SimpletextTableBody'
import Eye from "../../assets/Images/eye.png"

function HashtagList() {
    const { data, isLoading } = UsegetDashboardData()

    console.log("recentVendorsmonu", data?.data?.recentVendors);


    const navigate = useNavigate()


    // Action handlers
    const handleOpenStory = (user: any) => {
        navigate("/View-User");
        sessionStorage.setItem("user_id", user.id)
    };

    const defaultCurrency = sessionStorage.getItem("defaultCurrency")

    return (
        <div className="border border-bordercolor rounded-lg  2xl:w-[50%] w-full overflow-x-auto">
            {/* Scrollable Table Wrapper */}
            <div className="min-w-full">
                {/* Header */}
                <div className="flex items-center justify-between px-4 mt-4 mb-4">
                    <h2 className="text-textcolor font-poppins text-base font-semibold">Recent Subscribed Vendors</h2>
                    <Link to="/subscribed-vendor">
                        <p className="cursor-pointer text-[#484848] text-sm underline font-poppins">View All</p>
                    </Link>
                </div>

                {/* Table Container */}
                <div className="border border-bordercolor   rounded-lg mx-4 mb-4">
                    {/* Table Header */}
                    <div className="flex items-center px-4 py-4 text-left w-full  overflow-x-auto border-b bg-headercolortable border-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
                        <div className="w-[40%]"><WithoutSorttableHeader label="SUBSCRIBED VENDOR" /></div>
                        <div className="w-[15%]"><WithoutSorttableHeader label="PLAN NAME" /></div>
                        <div className="w-[10%]"><WithoutSorttableHeader label="PRICE" /></div>
                        <div className="w-[15%]"><WithoutSorttableHeader label="START DATE" /></div>
                        <div className="w-[20%]"><WithoutSorttableHeader label="EXPIRED DATE" /></div>
                        <div className="w-[10%]"><WithoutSorttableHeader label="STATUS" /></div>
                    </div>

                    {/* Table Body */}
                    <div className="relative">
                        {isLoading ? (
                            <div className="h-[400px] flex items-center justify-center">
                                <AvatarWithSpinner />
                            </div>
                        ) : data?.data.recentVendors?.length > 0 ? (
                            data.data.recentVendors.map((gift: any, index: number) => (
                                <div
                                    key={gift.gift_id}
                                    className={`flex items-center px-4 py-3 w-full border-b border-bordercolor sm:pl-8 text-sm font-poppins gap-4 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"}`}
                                >
                                    <div className="w-[40%]">
                                        <TableUserInfo
                                            profilePic={gift?.user?.profile_photo_url}
                                            username={`${gift.user?.first_name} ${gift.user?.last_name}  `}
                                            email={gift.user?.email || "N/A"}
                                            mobile={gift.country_code ? `${gift.country_code} ${gift.mobile || ""}` : "N/A"}
                                            onClick={() => { handleOpenStory(gift.user) }}
                                        />
                                    </div>

                                    <div className="w-[15%]">
                                        <SimpletextTableBody title={gift.plan_name} />
                                    </div>

                                    <div className="w-[10%]">
                                        <SimpletextTableBody title={`${defaultCurrency} ${gift.price}`} />
                                    </div>

                                    <div className="w-[15%]">
                                        <SimpletextTableBody title={gift.start_date} />
                                    </div>

                                    <div className="w-[20%]">
                                        <SimpletextTableBody title={gift.expire_date} />
                                    </div>

                                    {/* <div className="w-[8%] relative">
                    <div
                      className={`w-fit rounded-xl px-3 py-1 absolute left-[0.7rem] top-[-0.9rem] font-medium ${
                        gift?.payment_mode === "user"
                          ? "bg-[#D4F1E0] text-[#4CAF50]"
                          : gift?.payment_mode === "vendor"
                            ? "bg-[#D2DFF5] text-[#0046AE]"
                            : gift?.payment_mode === "stripe"
                              ? "bg-[#E0F7FA] text-[#00ACC1]"
                              : gift?.payment_mode === "flutterwave"
                                ? "bg-[#FFF3E0] text-[#FB8C00]"
                                : gift?.payment_mode === "razorpay"
                                  ? "bg-[#F3E5F5] text-[#8E24AA]"
                                  : "bg-gray-200 text-gray-600"
                      }`}
                    >
                      {{
                        user: "Customer",
                        vendor: "Vendor",
                        stripe: "Stripe",
                        flutterwave: "Flutterwave",
                        razorpay: "Razorpay",
                      }[gift?.payment_mode] || "Unknown"}
                    </div>
                  </div> */}

                                    <div className="w-[10%]">
                                        <div
                                            className={`w-fit rounded-xl px-3 py-1 font-normal ${gift?.status === "1"
                                                ? "bg-green-100 text-green-600"
                                                : "bg-red-100 text-red-600"
                                                }`}
                                        >
                                            {gift?.status === "1" ? "Active" : "Expired"}
                                        </div>
                                    </div>


                                </div>
                            ))
                        ) : (
                            <div className="p-4 w-full h-[30rem] flex justify-center items-center">
                                <div className="w-full flex flex-col items-center h-full justify-center">
                                    <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                                    <h2 className="font-poppins text-lg text-textcolor mt-4">No  Data Found</h2>
                                </div>
                            </div>
                        )}
                    </div>
                </div>
            </div>
        </div>
    )
}

export default HashtagList
