
import { useSelector } from 'react-redux'
import SearchBar from '../../Componets/SearchBar/SearchBar';
import TotalUsers from './TotalUsers';
import TotalPosts from './TotalPosts';
import UserGetByYear from './UserGetByYear';
import LoginType from './LoginType';
import DashboardUserList from './DashboardUserList';
import UsersByCountry from './UsersByCountry';
import PlatformActivity from './PlatformActivity';
import PostListDashborad from './PostListDashborad';
import TotalLive from './TotalLive';
import TotalEarning from './TotalEarning';
import HashtagList from './HashtagList';
import DashBoardSponcerGraph from './DashBoardSponcer/DashBoardSponcerGraph';
import SubscriptionEarning from './DashBoardSponcer/SubscriptionEarning';
import TotalServices from './DashBoardSponcer/TotalServices';
import { UsegetDashboardData } from '../../Appstore/Api/UsegetDashboardData';
import AvatarWithSpinner from '../../Componets/LoadingComponest';


function Dashboard() {
    const isSidebarOpen = useSelector((state: { sidebar: { isOpen: boolean } }) => state.sidebar.isOpen);
  const { data , isLoading} = UsegetDashboardData();

    if (isLoading) return <div className="h-full  w-full flex items-center justify-center">
    <AvatarWithSpinner/>
  </div>;

    return (
        <>
            <div className={` bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
                <SearchBar />



                <div className=' w-full flex py-8  gap-4  px-6 flex-col xl:flex-row xl:justify-between items-center'>
                    <DashBoardSponcerGraph />
                    <div className='  w-full grid h-full  xl:grid-cols-2  gap-4  grid-cols-1'>
                        <TotalUsers />
                        <TotalPosts />
                        <TotalLive />
                        <TotalEarning />
                        <TotalServices />
                        <SubscriptionEarning />
                    </div>
                </div>


                <div className='flex flex-col w-full gap-4 px-6 2xl:flex-row'>
                    <UserGetByYear />
                </div>

                <div className='flex flex-col w-full py-8 gap-4 px-6 xl:flex-row'>
                    <DashboardUserList />
                    <LoginType />
                </div>
                <div className='flex flex-col w-full gap-4 px-6 py-8 2xl:flex-row'>
                    <PostListDashborad />
                    <HashtagList />
                </div>
            </div>
        </>
    )
}

export default Dashboard



