import React, { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import { Link, useNavigate } from "react-router-dom";
import toast from "react-hot-toast";
import Eye from "../../assets/Images/eye.png";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import Search from "../../assets/Images/search.png";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import SortableHeader from "../../Componets/TableComponets/SortableHeader";
import StoryThumbnail from "../../Componets/TableComponets/StoryThumbnail";
import TableDateTimeDisplay from "../../Componets/TableComponets/TableDateTimeDisplay";
import PaginationComponets from "../../Componets/PaginationComponets";
import Loader from "../../assets/Images/Loader.gif";
import Add from "../../assets/Images/add.png";
import EditIcon from "../../assets/Images/edit.png";
import notfound from "../../assets/Images/notfound.png";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import { setPaginationValues } from "../../Appstore/Slice/PaginationValues";
import defaultPagination from "../../Appstore/Slice/PaginationValues";
import useApiPost from "../../Hooks/PostData";
import { showModal } from "../../Appstore/Slice/ModalSlice";
import Apimethod from "../../Hooks/Apimethod";
import { clearCoverImage } from "../../Appstore/Slice/AddImageSlice";
import { clearSelectedCategory } from "../../Appstore/Slice/CategorySelectedIDandValues";
import TableActionButtons from "../../Componets/TableComponets/TableActionButtons";
import { reset } from "../../Appstore/Slice/toggleSlice";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import TableUserInfo from "../../Componets/TableComponets/TableUserInfo";
import SimpletextTableBody from "../../Componets/TableComponets/SimpletextTableBody";

function Customer() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const dispatch = useAppDispatch();

    const [order, setOrder] = useState<string>("");

    const { data, loading, error, postData } = useApiPost();
    const sliceValues = useAppSelector((state) => state.toggle.value);
    const [search, setSearch] = useState("")


    const {
        current_page,
        records_per_page,
    } = useAppSelector(
        (state) => state.PaginationValues.giftPagination || defaultPagination
    );

    const [toggleStates, setToggleStates] = useState<{ [key: number]: boolean }>({});



    // Fetch data
    useEffect(() => {
        const params = {
            page: current_page,
            pageSize: records_per_page,
            ...(order !== null && order !== undefined && {
                orderBy: order === "1" ? "ASC" : "DESC",
            }),
            ...(search && { search: search }), // Add search term as 'name' in the body
        };

        postData("/customer-list", params);
    }, [current_page, records_per_page, order, search]);


    useEffect(() => {
        if (sliceValues) {
            const formdata = new FormData()
            postData("/customer-list", formdata);
        }
    }, [sliceValues])



    // Update pagination state
    useEffect(() => {
        if (data?.Pagination) {
            dispatch(
                setPaginationValues({
                    key: "giftPagination",
                    data: data.Pagination,
                })
            );
        }
    }, [data]);

    useEffect(() => {
        if (data?.customers) {
            const toggles = data?.customers.reduce((acc, gift) => {
                acc[gift.id] = gift.status;
                return acc;
            }, {} as { [key: number]: boolean });
            setToggleStates(toggles);
        }
    }, [data]);



    const { makeRequest } = Apimethod()


        const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleToggleStatus = async (giftId: number) => {

         if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const newStatus = !toggleStates[giftId];
        try {
            await makeRequest(
                "/user-statuschange",
                {
                    id: giftId,
                    status: newStatus ? 1 : 0, // convert boolean to 1 or 0
                },
                "application/json",
                "POST"
            );
            setToggleStates((prev) => ({
                ...prev,
                [giftId]: newStatus,
            }));
            toast.success("Gift status updated");
        } catch (err) {
            toast.error("Failed to update status");
        }
    };


    const navigate = useNavigate()


    // Action handlers
    const handleOpenStory = (user: any) => {
        console.log("ggggggggggg", user)

        navigate("/View-User");
        sessionStorage.setItem("user_id", user.id)
    };




    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-bordercolor py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">Customer List</h2>
                    <div className="relative">
                        <div className="absolute flex items-center p-2 transform -translate-y-1/2 left-2 top-1/2">
                            <img src={Search} alt="Search" className="w-4 h-4 md:w-5 md:h-5" />
                        </div>
                        <input
                            type="text"
                            className=" xl:placeholder:text-sm  bg-primary  text-textcolor border border-bordercolor  placeholder:dark:text-tableDarkLarge border-opacity-10 rounded-lg md:w-[250px] w-[180px] py-2 pl-10 placeholder:text-sm placeholder:text-textcolor0004F] focus:outline-none focus:ring-1 focus:ring-gray-600"
                            placeholder="Search by name , email..."
                            onChange={(e) => setSearch(e.target.value)}
                            value={search}
                        />
                    </div>
                </div>

                <div className="flex items-center justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base  font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]"></div>
                        <h3 className="text-[#858585] font-poppins text-base">Customer List</h3>
                    </div>

                </div>

                <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        <div className="flex px-4 py-3 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8">
                            <div className="w-[10%]"><WithoutSorttableHeader label="S.L" /></div>
                            <div className="w-[30%]"><WithoutSorttableHeader label="CUSTOMER" /></div>
                            <div className="w-[20%]"><WithoutSorttableHeader label="USERNAME" /></div>
                            <div className="w-[14%]"><WithoutSorttableHeader label="CONTACT NUMBER" /></div>
                            <div className="w-[20%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
                            <div className="w-[18%]"><WithoutSorttableHeader label="STATUS" /></div>
                            <div className="w-[14%]"><WithoutSorttableHeader label="ACTIONS" /></div>
                        </div>

                        <div className="relative">
                            {loading && (
                                <div className=" h-[400px] flex items-center justify-center  ">
                                    <AvatarWithSpinner />
                                </div>
                            )}

                            {!loading && data?.customers?.length > 0 ? (
                                data.customers.map((gift: any, index: number) => (
                                    <div key={gift.id} className={`  ${index % 2 === 0 ? 'bg-white dark:bg-primary' : 'bg-[#00162e0a] dark:bg-primary'
                                        } flex items-center px-4 py-3 border-b border-b-bordercolor sm:pl-8`}>
                                        <div className="w-[10%] text-sm text-textcolor font-poppins">
                                            {(current_page - 1) * records_per_page + index + 1}
                                        </div>
                                        <div className="w-[30%]">
                                            <TableUserInfo
                                                profilePic={gift.image}
                                                username={`${gift.first_name} ${gift.last_name}`} // Added space between first and last name
                                                email={gift.email || 'N/A'}
                                                mobile={gift.country_code ? `${gift.country_code} ${gift.mobile || ''}` : 'N/A'}
                                                onClick={() => handleOpenStory(gift)}
                                            />
                                        </div>

                                        <div className=" w-[20%]">
                                            <SimpletextTableBody title={gift.username} />
                                        </div>


                                        <div className=" w-[14%]">
                                            <SimpletextTableBody title={gift.mobile} />
                                        </div>



                                        <div className="w-[20%]"><TableDateTimeDisplay dateString={gift.created_at} /></div>
                                        <div className="w-[18%]">
                                            <label className="flex items-center cursor-pointer select-none">
                                                <div className="relative">
                                                    <input
                                                        type="checkbox"
                                                        checked={toggleStates[gift.id] || false}
                                                        onChange={() => handleToggleStatus(gift.id)}
                                                        className="sr-only"
                                                    />
                                                    <div className={`block h-6 w-10 rounded-full border transition duration-300 ${toggleStates[gift.id] ? " border-toggalbtcolorborder bggradient" : "bg-transparent  border  border-toggalbtcolorborder"}`}></div>
                                                    <div className={`absolute top-1 h-4 w-4 rounded-full transition duration-300 ${toggleStates[gift.id] ? "right-1 bg-white" : "left-1 bggradient"}`}></div>
                                                </div>
                                            </label>
                                        </div>
                                        <div className="w-[14%]  flex items-center gap-2">

                                            <TableActionButtons
                                                viewButtonIcon={Eye}
                                                onViewClick={() => handleOpenStory(gift)}
                                                viewButtonColor="#CCE1CD"
                                                borderColor="#01D312"
                                            />
                                        </div>
                                    </div>
                                ))
                            ) : !loading &&

                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <div className="w-full flex flex-col items-center h-full justify-center">
                                    <img
                                        src={notfound}
                                        alt="Not Found"
                                        className="w-1/2 max-h-[40vh] object-contain"
                                    />
                                    <h2 className="font-poppins text-lg text-textcolor  mt-4">
                                        No  Data Found
                                    </h2>
                                </div>
                            </div>

                            }
                        </div>
                    </div>


                    <PaginationComponets paginationKey="giftPagination" />

                </div>
            </div>
        </div>
    );
}

export default Customer;
