import { useEffect, useState } from 'react'
import { useSelector } from 'react-redux';
import { Link } from 'react-router-dom';
import Add from "../../assets/Images/add.png"
import SearchBar from '../../Componets/SearchBar/SearchBar';
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader';
import useApiPost from '../../Hooks/PostData';
import notfound from "../../assets/Images/notfound.png"
import { useAppDispatch, useAppSelector } from '../../Hooks/Hooks';
import SimpletextTableBody from '../../Componets/TableComponets/SimpletextTableBody';
import TableDateTimeDisplay from '../../Componets/TableComponets/TableDateTimeDisplay';
import { showModal } from '../../Appstore/Slice/ModalSlice';
import { reset } from '../../Appstore/Slice/toggleSlice';
import TableActionButtons from '../../Componets/TableComponets/TableActionButtons';
import Eye from "../../assets/Images/eye.png"
import AvatarWithSpinner from '../../Componets/LoadingComponest';
import Search from '../../assets/Images/search.png';
import StoryThumbnail from '../../Componets/TableComponets/StoryThumbnail';
import MusicListPagination from '../../Componets/PaginationComponets/MusicListPagination';
import { setPaginationMusiclList } from '../../Appstore/Slice/PaginationSlice/MusicListPaginationSlice';
import { clearCoverImage } from '../../Appstore/Slice/AddImageSlice';
import Block from "../../assets/Images/deleteicon.png";
import EditIcon from "../../assets/Images/edit.png"
import { setCategoryUpdate } from '../../Appstore/Slice/CategoryUpdateSlice';
import { clearCoverImageCategoryIcon } from '../../Appstore/Slice/CategoryIconSlice';
import toast from 'react-hot-toast';
function CategoryList() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const { data, loading, error, postData } = useApiPost();
    const [search, setSearch] = useState("")




    const pagination = useAppSelector((state) => state.MusicListPaginationSlice);
    const { current_page, records_per_page } = pagination;


    const [toggleStates, setToggleStates] = useState<{ [key: number]: boolean }>({});

    // Fetch data
    useEffect(() => {
        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim()


        };

        postData("/category-list", params);
    }, [current_page, records_per_page, search]);



    const isaddgiftvalues = useAppSelector((state) => state.toggle.value)


    useEffect(() => {

        if (isaddgiftvalues) {
            postData("/category-list", {});
        }

    }, [isaddgiftvalues])




    useEffect(() => {
        if (data?.data) {
            const toggles = data.data.reduce((acc, gift) => {
                acc[gift.id] = gift.status;
                return acc;
            }, {} as { [key: number]: boolean });
            setToggleStates(toggles);
        }
    }, [data]);



    const dispatch = useAppDispatch()


    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationMusiclList(data?.Pagination));
        }
    }, [data, dispatch]);







    const handleBlock = (id: string) => {
        
        sessionStorage.setItem("deleteCtId", id)
        dispatch(showModal("CategoryDeleteModal"))
        dispatch(reset())
    }


    const handleOpenStory = (gift: any) => {
        dispatch(showModal("CategoryListValuesShowModal"))
        sessionStorage.setItem("catid", gift?.id)

    }


    const handalupdatecategory = (gift: any) => {
       

        console.log(" my update categpoy values", gift)


        dispatch(setCategoryUpdate({
            status: true,
            message: "Category selected",
            category: gift,
        }));

        dispatch(showModal("CategoryUpdateModal"))
    };






    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">Category List</h2>
                    <div className="relative">
                        <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
                            <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
                        </div>
                        <div className=' w-full'>
                            <input
                                type="text"
                                placeholder="Search by Category..."
                                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "

                                onChange={(e) => setSearch(e.target.value)}
                                value={search}
                            />
                        </div>
                    </div>
                </div>

                <div className="flex items-center flex-col gap-y-4 md:flex-row justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base  font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]"></div>
                        <h3 className="text-[#858585] font-poppins text-base">Category List</h3>
                    </div>

                    <button
                        className="flex gap-1.5 mr-1 py-2 cursor-pointer place-items-center px-4 font-poppins font-medium text-white rounded-md bggradient"

                        onClick={() => {
                           
                            dispatch(showModal("AddCategoryModal"))
                            dispatch(reset())
                            dispatch(clearCoverImage())
                            dispatch(clearCoverImageCategoryIcon())
                        }}

                    >
                        <img src={Add} className="w-4 h-4" />
                        <p className="md:text-sm text-xs">Add Category</p>
                    </button>
                </div>


                <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        <div className="flex px-4 py-3 text-left border-b w-full bg-headercolortable border-b-bordercolor sm:pl-8">
                            <div className="w-[5%]"><WithoutSorttableHeader label="S.L" /></div>
                            <div className="w-[15%]"><WithoutSorttableHeader label="CATEGORY NAME" /></div>
                            <div className="w-[15%]"><WithoutSorttableHeader label="CATEGORY IMAGE" /></div>
                            <div className="w-[15%]"><WithoutSorttableHeader label="CATEGORY ICON" /></div>
                            <div className="w-[17%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="TOTAL STORES" /></div>
                            <div className="w-[13%]"><WithoutSorttableHeader label="TOTAL SUBCATEGORIES" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="ACTIONS" /></div>
                        </div>


                        <div className="relative">
                            {loading && (
                                <div className=" h-[400px] flex items-center justify-center  ">
                                    <AvatarWithSpinner />
                                </div>
                            )}

                            {!loading && data?.data?.length > 0 ? (
                                data.data.map((gift: any, index: number) => (
                                    <div key={gift.gift_id} className={`    ${index % 2 === 0 ? 'bg-white dark:bg-primary' : 'bg-[#00162e0a] dark:bg-primary'
                                        } flex items-center px-4 py-3 border-b border-b-bordercolor sm:pl-8`}>
                                        <div className="w-[5%] text-sm text-textcolor font-poppins">
                                            {(current_page - 1) * records_per_page + index + 1}
                                        </div>

                                        <div className=' w-[15%]'>
                                            <SimpletextTableBody title={gift.category_name} />
                                        </div>

                                        <div className=' w-[15%] ml-4'>
                                            <StoryThumbnail url={gift.category_image} storyId={gift.id} onClick={() => handleOpenStory(gift)} />

                                        </div>
                                        <div className=' w-[15%] ml-4'>
                                            <StoryThumbnail url={gift.category_icon} storyId={gift.id} onClick={() => handleOpenStory(gift)} />

                                        </div>

                                        <div className=' w-[17%]'>
                                            <TableDateTimeDisplay dateString={gift.created_at} />

                                        </div>
                                        <div className=' w-[10%] pl-6'>
                                            <SimpletextTableBody title={gift.total_services} />
                                        </div>

                                        <div className=' w-[13%] pl-6'>
                                            <SimpletextTableBody title={gift.subcategories_count} />
                                        </div>


                                        <div className=' w-[10%] flex gap-3'>
                                            <button className=" py-[9px] px-[10px] cursor-pointer bg-[#D0CCE1]/60 rounded-full" onClick={() => handalupdatecategory(gift)} >
                                                <img src={EditIcon} alt="Edit" className="w-5 h-4" />
                                            </button>
                                            <TableActionButtons
                                                viewButtonIcon={Eye}
                                                onViewClick={() => handleOpenStory(gift)}
                                                viewButtonColor="#CCE1CD"
                                                borderColor="#01D312"
                                                blockButtonIcon={Block}
                                                onBlockClick={() => handleBlock(gift.id)}
                                            />
                                        </div>


                                    </div>
                                ))
                            ) : !loading &&

                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <div className="w-full flex flex-col items-center h-full justify-center">
                                    <img
                                        src={notfound}
                                        alt="Not Found"
                                        className="w-1/2 max-h-[40vh] object-contain"
                                    />
                                    <h2 className="font-poppins text-lg text-textcolor  mt-4">
                                        No  Data Found
                                    </h2>
                                </div>
                            </div>

                            }
                        </div>
                    </div>

                    <MusicListPagination />
                </div>
            </div>

        </div>
    )
}

export default CategoryList
