import { useEffect, useState } from 'react';
import { useSelector } from 'react-redux';
import { Link, useNavigate } from 'react-router-dom';
import SearchBar from '../../Componets/SearchBar/SearchBar';
import Search from '../../assets/Images/search.png';
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader';
import SortableHeader from '../../Componets/TableComponets/SortableHeader';
import useApiPost from '../../Hooks/PostData';
import TableUserInfo from '../../Componets/TableComponets/TableUserInfo';
import TableDateTimeDisplay from '../../Componets/TableComponets/TableDateTimeDisplay';
import Eye from '../../assets/Images/eye.png';
import TableActionButtons from '../../Componets/TableComponets/TableActionButtons';
import PostListPagination from '../../Componets/PaginationComponets/PostListPagination';
import { useAppDispatch, useAppSelector } from '../../Hooks/Hooks';
import { setPaginationPostlList } from '../../Appstore/Slice/PaginationSlice/PostListPaginationSlice';
import notfound from "../../assets/Images/notfound.png";
import Apimethod from '../../Hooks/Apimethod';
import toast from 'react-hot-toast';
import AvatarWithSpinner from '../../Componets/LoadingComponest';


function AllUserList() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const [category, setCategory] = useState<string>('');
    const [order, setOrder] = useState<string>('');
    const { data, loading, postData } = useApiPost();
    const [postList, setPostList] = useState<any[]>([]);
    const dispatch = useAppDispatch();
    const pagination = useAppSelector((state) => state.PostListPaginationSlice);
    const [search, setSearch] = useState("")

    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';




    const { current_page, records_per_page } = pagination;

    const fetchData = () => {
        const formData = new FormData();
        formData.append("social_type", "reel");
        formData.append("page", current_page.toString());
        formData.append("pageSize", records_per_page.toString());
        if (search.trim() !== "") {
            formData.append("search", search.trim());
        }



        //     cheack categoty name values

        if (category === "CREATED DATE/TIME") {
            formData.append("sort_by", "createdAt");
        }
        else if (category === "STATUS") {
            formData.append("sort_by", "status");
        }

        else if (category === "total_comments") {
            formData.append("total_comments1212", category);
        }
        // Convert order value: 0 -> DESC, 1 -> ASC
        if (order !== null && order !== undefined) {
            const sortOrder = order === "1" ? "ASC" : "DESC";
            formData.append("orderBy", sortOrder);
        }
        postData("/allusers-list", formData);
    };

    useEffect(() => {
        fetchData();
    }, [current_page, records_per_page, search, category, order]);




    console.log(" my api responce values from the user list api ", data?.allusers)

    // Update postList when data changes
    useEffect(() => {
        if (data?.allusers) {
            setPostList(data?.allusers);
        }
    }, [data]);

    // Update pagination state when data changes
    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationPostlList(data?.Pagination));
        }
    }, [data, dispatch]);

    const navigate = useNavigate();


    // Action handlers
    const handleOpenStory = (user: any) => {
        console.log("my all user detail", user);

        if (user.role === "vendor") {
            navigate("/View-Vendor", { state: { user } });
            sessionStorage.setItem("user_id", user.id)
        } else if (user.role === "user") {
            navigate("/View-User", { state: { user } });
            sessionStorage.setItem("user_id", user.id)
        } else {
            console.warn("Unknown role:", user.role);
        }
    };






    const handleUserClick = () => alert('User clicked');


    const handleBlock = () => alert('Block button clicked');



    const [toggleStates, setToggleStates] = useState<{ [key: number]: boolean }>({});


    useEffect(() => {
        if (data?.allusers) {
            const toggles = data?.allusers.reduce((acc, gift) => {
                acc[gift.id] = gift.status;
                return acc;
            }, {} as { [key: number]: boolean });
            setToggleStates(toggles);
        }
    }, [data]);


    const { makeRequest } = Apimethod()

    const handleToggleStatus = async (giftId: number) => {
        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }

        const newStatus = !toggleStates[giftId];
        try {
            await makeRequest(
                "/user-statuschange",
                {
                    id: giftId,
                    status: newStatus ? 1 : 0, // convert boolean to 1 or 0
                },
                "application/json",
                "POST"
            );
            setToggleStates((prev) => ({
                ...prev,
                [giftId]: newStatus,
            }));
            toast.success("Status changed successfully");
        } catch (err) {
            toast.error("Failed to update status");
        }
    };




    return (
        <div className={`bg-primary ${isSidebarOpen ? 'xl:pl-20' : 'xl:pl-72'}`}>
            <SearchBar />

            <div className="px-4 pb-10 xl:px-6">
                {/* Header */}
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">
                        AllUser List
                    </h2>
                    <div className="relative">
                        <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
                            <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
                        </div>
                        <div className=' w-full'>
                            <input
                                type="text"
                                placeholder="Search by name ,email..."
                                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "

                                onChange={(e) => setSearch(e.target.value)}
                                value={search}
                            />
                        </div>
                    </div>
                </div>

                {/* Breadcrumb */}
                <div className="mb-4 flex items-center gap-2">
                    <Link to="/dashboard">
                        <h3 className="text-base font-semibold text-[#3A3A3A]  font-poppins">Dashboard</h3>
                    </Link>
                    <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
                    <h3 className="text-base text-[#858585] font-poppins"> AllUser List</h3>
                </div>

                {/* Table */}
                <div className="w-full overflow-x-auto rounded-lg border border-bordercolor mt-6">
                    <div className="min-w-[1200px]">
                        {/* Table Header */}
                        <div className="flex bg-headercolortable px-4 py-3 text-left font-medium border-b border-b-bordercolor sm:pl-8">
                            <div className="w-[8%]"><WithoutSorttableHeader label="S.L" /></div>
                            <div className="w-[22%]">
                                <WithoutSorttableHeader label="USER" />
                            </div>
                            <div className="w-[13%]"><WithoutSorttableHeader label="ROLE" /></div>

                            <div className="w-[18%]">
                                <SortableHeader
                                    title="CREATED DATE/TIME"
                                    category={category}
                                    order={order}
                                    setCategory={setCategory}
                                    setOrder={setOrder}
                                />
                            </div>
                            <div className="w-[12%]">
                                <WithoutSorttableHeader label="USERNAME" />
                            </div>
                            <div className="w-[13%]">
                                <WithoutSorttableHeader label="CONTACT NUMBER" />
                            </div>
                            <div className="w-[10%]">
                                <SortableHeader
                                    title="STATUS"
                                    category={category}
                                    order={order}
                                    setCategory={setCategory}
                                    setOrder={setOrder}
                                />
                            </div>

                            <div className="w-[10%]"><WithoutSorttableHeader label="ACTIONS" /></div>
                        </div>




                        {loading ? (
                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <AvatarWithSpinner />
                            </div>
                        ) : postList.length > 0 ? (
                            postList.map((user: any, index: number) => (
                                <div
                                    key={user.id}
                                    className={`flex items-center px-4 py-3 border-b border-b-bordercolor  ${index % 2 === 0 ? 'bg-white dark:bg-primary' : 'bg-[#00162e0a] dark:bg-primary'
                                        }    sm:pl-8`}
                                >
                                    <div className="w-[8%] text-sm font-poppins text-textcolor"> {(current_page - 1) * records_per_page + index + 1}</div>

                                    <div className="w-[22%]">
                                        <TableUserInfo
                                            profilePic={user.image}
                                            username={`${user.first_name} ${user.last_name}`} // Added space between first and last name
                                            email={user.email || 'N/A'}
                                            mobile={user.country_code ? `${user.country_code} ${user.mobile || ''}` : 'N/A'}
                                            onClick={() => handleOpenStory(user)}
                                        />

                                    </div>

                                    <div className="w-[13%] mr-[3rem]">
                                        <div
                                            className={`rounded-xl px-3 py-1 text-sm font-normal w-fit 
      ${user?.role === 'user'
                                                    ? 'bg-[#D4F1E0] text-[#4CAF50]'     // Customer style
                                                    : 'bg-[#D2DFF5] text-[#0046AE]'     // Vendor style
                                                }`}
                                        >
                                            {user?.role === 'user' ? 'Customer' : 'Vendor'}
                                        </div>
                                    </div>




                                    <div className="w-[18%]">
                                        <TableDateTimeDisplay dateString={user.created_at} />
                                    </div>

                                    <div className="w-[12%] text-sm line-clamp-1 font-poppins text-[#3A3A3A] dark:text-tableDarkLarge">
                                        {
                                            user?.username
                                        }
                                    </div>

                                    <div className="w-[13%] text-sm font-poppins text-[#3A3A3A] dark:text-tableDarkLarge">
                                        {
                                            user?.mobile
                                        }
                                    </div>

                                    <div className="w-[10%]">


                                        <label className="flex items-center cursor-pointer select-none">
                                            <div className="relative">
                                                <input
                                                    type="checkbox"
                                                    checked={toggleStates[user.id] || false}
                                                    onChange={() => handleToggleStatus(user.id)}
                                                    className="sr-only"
                                                />
                                                <div className={`block h-6 w-10 rounded-full border transition duration-300 ${toggleStates[user.id] ? " border-toggalbtcolorborder bggradient" : "bg-transparent  border  border-toggalbtcolorborder"}`}></div>
                                                <div className={`absolute top-1 h-4 w-4 rounded-full transition duration-300 ${toggleStates[user.id] ? "right-1 bg-white" : "left-1 bggradient"}`}></div>
                                            </div>
                                        </label>
                                    </div>

                                    <div className="w-[10%] pl-5">
                                        <TableActionButtons
                                            viewButtonIcon={Eye}
                                            onViewClick={() => handleOpenStory(user)}
                                            onBlockClick={handleBlock}
                                            viewButtonColor="#CCE1CD"
                                            borderColor="#01D312"
                                        />
                                    </div>
                                </div>
                            ))
                        ) : (
                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <div className="w-full flex flex-col items-center h-full justify-center">
                                    <img
                                        src={notfound}
                                        alt="Not Found"
                                        className="w-1/2 max-h-[40vh] object-contain"
                                    />
                                    <h2 className="font-poppins text-lg text-textcolor mt-4">
                                        Don't have any data to show
                                    </h2>
                                </div>
                            </div>
                        )}
                    </div>

                    <PostListPagination />

                </div>
            </div>
        </div>
    );
}

export default AllUserList;
