import React, { useState } from 'react';
import { MdOutlineChevronRight, MdOutlineCheck } from 'react-icons/md';
import { useDispatch } from 'react-redux';
import { setStatus } from '../../Appstore/Slice/AddVendorSlice'; // adjust path as needed

const StatusVendor = () => {
    const dispatch = useDispatch();

    const [searchValue, setSearchValue] = useState('');
    const [showDropdown, setShowDropdown] = useState(false);
    const [selectedStatus, setSelectedStatus] = useState('');
    const [rotate, setRotate] = useState(false);

    const statusOptions = ['Active', 'Inactive'];

    const handleToggle = () => {
        setShowDropdown(!showDropdown);
        setRotate(!rotate);
    };

    const handleSelectStatus = (status: string) => {
        setSelectedStatus(status);
        setSearchValue(status);
        setShowDropdown(false);
        setRotate(false);

        // 👇 Dispatch status as 1 or 0
        dispatch(setStatus(status === 'Active' ? 1 : 0));
    };

    const handleClear = () => {
        setSelectedStatus('');
        setSearchValue('');
        dispatch(setStatus(null)); // reset if needed
    };

    return (
        <div className="w-full flex flex-col relative h-full">
            <label htmlFor="status" className="font-poppins text-sm font-normal text-textcolor">
                Status
                <span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative mt-2 flex items-center cursor-pointer">
                <input
                    type="text"
                    id="status"
                    name="status"
                    autoComplete="off"
                    spellCheck="false"
                    className="w-full rounded-lg border border-bordercolor text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:font-gilroy_regular placeholder:text-sm placeholder:text-textcolor placeholder:opacity-50 focus:outline-none focus:ring-1 focus:ring-header"
                    placeholder="Select status"
                    value={searchValue}
                    onFocus={() => setShowDropdown(true)}
                    onBlur={() => setTimeout(() => setShowDropdown(false), 200)}
                    onChange={(e) => setSearchValue(e.target.value)}
                />
                <div
                    className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? 'rotate-90' : '-rotate-90'}`}
                    onClick={handleToggle}
                >
                    <MdOutlineChevronRight className="text-xl" />
                </div>
            </div>

            {selectedStatus && (
                <div className="flex flex-wrap mt-2 gap-2">
                    <span className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins">
                        {selectedStatus}
                        <button className="ml-2 text-red-500 hover:text-red-700" onClick={handleClear}>×</button>
                    </span>
                </div>
            )}

            {showDropdown && (
                <ul className="absolute top-[5.9rem] left-0 w-full bg-primary text-textcolor rounded-lg shadow-lg z-10 border border-bordercolor mt-1">
                    {statusOptions
                        .filter((status) => status.toLowerCase().includes(searchValue.toLowerCase()))
                        .map((status) => (
                            <li
                                key={status}
                                className="px-4 py-2 cursor-pointer font-poppins hover:bg-gray-200 text-textcolor flex justify-between items-center"
                                onMouseDown={() => handleSelectStatus(status)}
                            >
                                {status}
                                {selectedStatus === status && (
                                    <MdOutlineCheck className="text-[#6565657a] text-lg" />
                                )}
                            </li>
                        ))}
                    {statusOptions.filter((s) =>
                        s.toLowerCase().includes(searchValue.toLowerCase())
                    ).length === 0 && (
                            <li className="px-4 py-2 font-poppins text-center text-gray-500">No status found</li>
                        )}
                </ul>
            )}
        </div>
    );
};

export default StatusVendor;
