import { useState } from "react";
import { useSelector } from "react-redux";
import { useNavigate, useLocation, Link } from "react-router-dom";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import FormGlobalInputAnalytical from "../../Componets/Form/FormGlobalINputNlytical";
import PhoneNumberAddVendor from "./PhoneNumberAddVendor";
import UserNameCheack from "./UserNameCheack";
import AddProfile from "./AddProfile";
import StatusVendor from "./StatusVendor";
import useApiPost from "../../Hooks/PostData";
import { useAppSelector } from "../../Hooks/Hooks";
import toast from "react-hot-toast";
import { MdArrowBack } from "react-icons/md";

function AddVendor() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const navigate = useNavigate();
    const location = useLocation();
    const { loading, postData } = useApiPost();

    const currentPath = location.pathname.split("/");
    const sourcePage = currentPath[1] || "user-list";

    const [formData, setFormData] = useState({
        first_name: "",
        last_name: "",
        email: "",
        password: "",
        confirm_pwd: "",
    });

    const addVendorSlicevalues = useAppSelector((state) => state.addVendor);
    const coverImage = useAppSelector((state) => state.UploadServiceAttactmentSlice.cover_image);


    console.log("coverImagecoverImage", coverImage)

    const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const { name, value } = e.target;
        setFormData((prevData) => ({
            ...prevData,
            [name]: value,
        }));
    };



    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';

    const handleSubmit = async () => {
        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const { first_name, last_name, email, password, confirm_pwd } = formData;
        const {
            username,
            countryCode,
            nationalNumber,
            status,
            isUsernameAvailable
        } = addVendorSlicevalues;

        if (!status || status === "null") {
            return toast.error("Please select a status.");
        }

        const requiredFields = [
            { label: "First Name", value: first_name },
            { label: "Last Name", value: last_name },
            { label: "Email", value: email },
            { label: "Password", value: password },
            { label: "Confirm Password", value: confirm_pwd },
            { label: "Username", value: username },
            { label: "Country Code", value: countryCode },
            { label: "Mobile Number", value: nationalNumber },
            { label: "Profile Image", value: coverImage },
        ];

        for (const field of requiredFields) {
            if (!field.value || (typeof field.value === "string" && !field.value.trim())) {
                return toast.error(`${field.label} is required.`);
            }
        }

        if (isUsernameAvailable === false) {
            return toast.error("Username is already taken.");
        }

        if (password !== confirm_pwd) {
            return toast.error("Passwords do not match.");
        }

        const passwordRegex = /^(?=.*[A-Za-z])(?=.*\d)(?=.*[^A-Za-z\d]).{6,}$/;
        if (!passwordRegex.test(password)) {
            return toast.error("Password must include letters, numbers & special characters.");
        }

        if (!(coverImage instanceof File)) {
            return toast.error("Invalid image file.");
        }

        const payload = new FormData();
        payload.append("first_name", first_name.trim());
        payload.append("last_name", last_name.trim());
        payload.append("email", email.trim());
        payload.append("password", password);
        payload.append("conform_password", confirm_pwd);
        payload.append("country_code", countryCode);
        payload.append("mobile", nationalNumber);
        payload.append("username", username.trim());
        payload.append("status", status);
        payload.append("image", coverImage);

        try {
            const res = await postData("/add-vendor", payload, 'multipart/form-data');

            console.log("API Response:", res);

            if (res?.status) {
                toast.success(res?.message || "Vendor added successfully.");
                navigate(`/${sourcePage}`);
            } else {
                toast.error(res?.message || "Something went wrong.");
            }

        } catch (error: any) {
            console.error("Submit Error:", error);

            // Axios specific error handling
            if (error?.response) {
                console.log("Error Response:", error.response);

                const errorMessage =
                    error.response?.data?.message ||
                    error.response?.data?.error ||
                    "Validation failed with status 422";

                toast.error(errorMessage);
            } else {
                toast.error(error?.message || "Something went wrong.");
            }
        }



    };







    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            {/* <div className="flex justify-between border-t-[#F2F2F2] py-3 px-6">
                <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">Add Vendor</h2>
            </div>

            <div className="flex items-center justify-between px-6">
                <div className="flex items-center gap-2">
                    <h3 className="text-[#3A3A3A] font-poppins text-base font-semibold cursor-pointer" onClick={() => navigate("/dashboard")}>
                        Dashboard
                    </h3>
                    <div className="rounded-full w-1 h-1 bg-[#808080]" />
                    <button className="text-[#3A3A3A] font-poppins font-semibold text-base cursor-pointer" onClick={() => navigate(`/${sourcePage}`)}>
                        {sourcePage
                            .split("-")
                            .map((word) => word.charAt(0).toUpperCase() + word.slice(1))
                            .join(" ")}
                    </button>
                </div>
            </div> */}
            <div className="px-4 pb-10 xl:px-6">
                <div className="w-full flex justify-between items-center gap-2">
                    {/* Left Content */}
                    <div className="flex flex-col">
                        {/* Header */}
                        <div className="flex justify-between border-t-[#F2F2F2] py-3">
                            <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">
                                Add Vendor
                            </h2>
                        </div>

                        {/* Breadcrumb */}
                        <div className="mb-4 flex items-center gap-2">
                            <Link to="/dashboard">
                                <h3 className="text-base font-semibold text-[#3A3A3A] font-poppins">
                                    Dashboard
                                </h3>
                            </Link>
                            <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
                            <button className="text-[#3A3A3A] font-poppins font-semibold text-base cursor-pointer" onClick={() => navigate(`/${sourcePage}`)}>
                                {sourcePage
                                    .split("-")
                                    .map((word) => word.charAt(0).toUpperCase() + word.slice(1))
                                    .join(" ")}
                            </button>
                        </div>
                    </div>

                    {/* Back Button */}
                    <button
                        onClick={() => navigate(-1)} // go back
                        className="flex items-center gap-2 px-4 py-[6px] text-white cursor-pointer bggradient font-poppins rounded-md"
                    >
                        <MdArrowBack size={20} />
                        Back
                    </button>
                </div>
            </div>

            <div className="mx-auto w-[97%] border border-bordercolor mt-12 rounded-lg p-4">
                <div className="md:flex gap-3 flex-col">
                    <div className="w-full grid grid-cols-1 md:grid-cols-2 gap-4">
                        <FormGlobalInputAnalytical label="First Name" name="first_name" value={formData.first_name} onChange={handleChange} required placeholder="Enter First Name" />
                        <FormGlobalInputAnalytical label="Last Name" name="last_name" value={formData.last_name} onChange={handleChange} required placeholder="Enter Last Name" />
                        <FormGlobalInputAnalytical label="Email" name="email" value={formData.email} onChange={handleChange} required placeholder="Enter Email" />
                        <PhoneNumberAddVendor />
                        <FormGlobalInputAnalytical
                            label="Password"
                            name="password"
                            value={formData.password}
                            onChange={handleChange}
                            required
                            placeholder="Enter Password"
                            labeloptionalvalues="Should contain alphabets, numbers & special characters"
                        />
                        <FormGlobalInputAnalytical
                            label="Confirm Password"
                            name="confirm_pwd"
                            value={formData.confirm_pwd}
                            onChange={handleChange}
                            required
                            placeholder="Confirm Password"
                            labeloptionalvalues="Must match the password"
                        />
                        <UserNameCheack />
                        <AddProfile />
                    </div>

                    <div className="w-full">
                        <StatusVendor />
                    </div>

                    <div className="w-full flex justify-center items-center">
                        <button
                            className={`w-fit px-[3rem] py-2 rounded-lg cursor-pointer font-poppins text-white flex items-center justify-center gap-2 transition-all duration-300
                            ${loading ? "bg-gray-400 cursor-not-allowed" : "bggradient"}`}
                            onClick={handleSubmit}
                            disabled={loading}
                        >
                            {loading && (
                                <svg className="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                    <circle className="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="4"></circle>
                                    <path className="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4l3-3-3-3v4a8 8 0 100 16v-4l-3 3 3 3v-4a8 8 0 01-8-8z"></path>
                                </svg>
                            )}
                            {loading ? "Submitting..." : "Submit"}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    );
}

export default AddVendor;
