import React from 'react';
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import { updateAddPostData } from '../../../Appstore/Slice/Storevalues/AddStoreSlice';
import FormGlobalInputAnalytical from '../../../Componets/Form/FormGlobalINputNlytical';
import MetaDescription from './MetaDescription';
import useApiPost from '../../../Hooks/PostData';
import { useNavigate } from 'react-router-dom';
import toast from 'react-hot-toast';
import AddStoreMetaDescription from './AddStoreMetaDescription';

function MetaData() {
  const dispatch = useAppDispatch();
  const formState = useAppSelector((state) => state.AddStoreSlice);

  const {
    service_name, service_email,
    service_website, service_phone, address,
    area, city, state, open_time,
    close_time, whatsapp_link, instagram_link, facebook_link, twitter_link,
    published_month,
    published_year, meta_title, service_country_code,
    video_url,
    employee_strength
  } = formState;



  console.log("video_urlvideo_urlmonu", video_url)





  const navigate = useNavigate();


  const selectedDaysOpenDays = useAppSelector((state) => state.openDay.selectedDays);
  const selectedCategory = useAppSelector((state) => state.category.selectedCategory?.id);
  const selectedSubCategories = useAppSelector((state) => state.subcategory.selectedSubCategories);
  const vendor_id = useAppSelector((state) => state.vendor.selectedVendor?.id);
  const service_description = useAppSelector((state) => state.StoreaddDescription.service_description);
  const service_description12 = useAppSelector((state) => state.AddSubcriptionDescription.service_description12);
  const coverImage = useAppSelector((state) => state.UploadServiceAttactmentSlice.cover_image);
  const Storeimage = useAppSelector((state) => state.UploadAddserviceImageSlice);
  const location = useAppSelector((state) => state.CurrentLocationSlice);
  const selectedLocation = useAppSelector((state) => state.location);

  const { loading, postData } = useApiPost();

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    const { name, value } = e.target;
    dispatch(updateAddPostData({ [name]: value }));
  };

  const handlePreviousStep = () => {
    if ((formState.add_new_post_steps ?? 0) > 1) {
      dispatch(updateAddPostData({
        add_new_post_steps: ((formState.add_new_post_steps ?? 0) - 1) as 1 | 2 | 3,
      }));
    }
  };

  const finalLat = selectedLocation.lat ?? location.latitude;
  const finalLng = selectedLocation.lng ?? location.longitude;


  const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const handleSubmit = () => {


    if (IS_DEMO) {
      toast.error("This action is disabled in the demo version.");
      return;
    }
    const formData = new FormData();

    const dayMap: { [key: string]: string } = {
      Monday: 'Mon', Tuesday: 'Tue', Wednesday: 'Wed',
      Thursday: 'Thu', Friday: 'Fri', Saturday: 'Sat', Sunday: 'Sun'
    };

    const allDays = Object.keys(dayMap);
    const openDaysStr = selectedDaysOpenDays.map(day => dayMap[day]).join(', ');
    const closeDaysStr = allDays.filter(day => !selectedDaysOpenDays.includes(day)).map(day => dayMap[day]).join(', ');

    formData.append("lat", finalLat || "");
    formData.append("lon", finalLng || "");
    formData.append("open_days", openDaysStr);
    formData.append("closed_days", closeDaysStr);
    formData.append("meta_title", meta_title || "");
    formData.append("employee_strength", employee_strength || "")
    formData.append("meta_description", service_description12 || "");
    formData.append("service_name", service_name || "");
    formData.append("vendor_id", vendor_id ? String(vendor_id) : "");
    formData.append("service_description", service_description || "");
    formData.append("category_id", selectedCategory || "");
    if (close_time) formData.append("close_time", close_time);
    if (open_time) formData.append("open_time", open_time);
    formData.append("subcategory_id", Array.isArray(selectedSubCategories)
      ? selectedSubCategories.map((item) => item.id).join(",")
      : "");
    if (published_month) formData.append("published_month", published_month);
    if (published_year) formData.append("published_year", published_year);
    if (service_email) formData.append("service_email", service_email);
    if (service_phone) formData.append("service_phone", service_phone);
    if (service_country_code) formData.append("service_country_code", service_country_code);
    if (service_website) formData.append("service_website", service_website);
    if (facebook_link) formData.append("facebook_link", facebook_link);
    if (instagram_link) formData.append("instagram_link", instagram_link);
    if (twitter_link) formData.append("twitter_link", twitter_link);
    if (whatsapp_link) formData.append("whatsapp_link", whatsapp_link);
    if (video_url) formData.append("video_url", video_url);
    if (address) formData.append("address", address);
    if (area) formData.append("area", area);
    if (city) formData.append("city", city);
    if (state) formData.append("state", state);
    if (coverImage) formData.append("cover_image", coverImage);

    Storeimage.cover_images.forEach((file: File) => {
      formData.append('service_images[]', file);
    });

    postData("/add-service", formData, "multipart/form-data")
      .then((res) => {
        console.log("Successfully submitted", res);
        toast.success('Store uploaded successfully!');

        navigate("/store-list")
      })
      .catch((err) => {
        console.error("Submission error", err);
      });
  };

  return (
    <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid gap-4">
        <FormGlobalInputAnalytical
          label="Meta Title"
          name="meta_title"
          value={formState.meta_title || ""}
          onChange={handleChange}
          required
          placeholder="Enter Meta Title"
        />
        <AddStoreMetaDescription />
        {/* <MetaDescription /> */}
      </div>

      {/* Previous and Submit buttons */}
      <div className="w-full flex justify-center gap-9 items-center">
        <button
          className={`w-fit px-[3rem] py-2 rounded-lg cursor-pointer font-poppins text-white 
    ${loading ? 'bg-gray-400 cursor-not-allowed' : 'bggradient'}`}
          onClick={handlePreviousStep}
          disabled={loading}
        >
          Previous
        </button>


        <button
          className={`w-fit px-[3rem] py-2 rounded-lg   cursor-pointer font-poppins text-white flex items-center justify-center gap-2 transition-all duration-300
      ${loading ? 'bg-gray-400 cursor-not-allowed' : 'bggradient'}`}
          onClick={handleSubmit}
          disabled={loading}
        >
          {loading && (
            <svg
              className="animate-spin h-5 w-5 text-white"
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 24 24"
            >
              <circle
                className="opacity-25"
                cx="12"
                cy="12"
                r="10"
                stroke="currentColor"
                strokeWidth="4"
              ></circle>
              <path
                className="opacity-75"
                fill="currentColor"
                d="M4 12a8 8 0 018-8v4l3-3-3-3v4a8 8 0 100 16v-4l-3 3 3 3v-4a8 8 0 01-8-8z"
              ></path>
            </svg>
          )}
          {loading ? "Submitting..." : "Submit"}
        </button>
      </div>

    </div>
  );
}

export default MetaData;
