import React, { useEffect, useRef, useState } from 'react';
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import { updateSubplanData } from '../../../Appstore/Slice/AddSubcriptionDescription';

function AddStoreMetaDescription() {
    const editorRef = useRef<HTMLDivElement>(null);
    const quillInstance = useRef<any>(null);
    const [isQuillReady, setIsQuillReady] = useState(false);

    const dispatch = useAppDispatch();
    const { service_description12 } = useAppSelector(
        (state) => state.AddSubcriptionDescription || ""
    );



    console.log("service_descriptionservice_descriptionservice_description", service_description12)

    // Load Quill CSS
    useEffect(() => {
        const quillCSS = document.createElement('link');
        quillCSS.rel = 'stylesheet';
        quillCSS.href = 'https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css';
        document.head.appendChild(quillCSS);
    }, []);

    // Load Quill JS dynamically
    useEffect(() => {
        const script = document.createElement('script');
        script.src = 'https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.js';
        script.onload = () => setIsQuillReady(true);
        document.body.appendChild(script);
    }, []);

    // Initialize Quill once
    useEffect(() => {
        if (isQuillReady && window.Quill && editorRef.current && !quillInstance.current) {
            quillInstance.current = new window.Quill(editorRef.current, {
                theme: 'snow',
                placeholder: 'Write your meta description here...',
            });

            // Add text change handler
            quillInstance.current.on('text-change', () => {
                const html = editorRef.current?.querySelector('.ql-editor')?.innerHTML || '';
                // dispatch(StoreaddDescriptionState({ service_description: html }));
                dispatch(updateSubplanData({ service_description12: html }));
            });

            // Set initial content
            if (service_description12) {
                quillInstance.current.clipboard.dangerouslyPasteHTML(service_description12);
            }
        }
    }, [isQuillReady]);

    // Sync Redux value into Quill when updated externally
    useEffect(() => {
        const currentHtml = quillInstance.current?.root.innerHTML;
        if (
            quillInstance.current &&
            service_description12 &&
            currentHtml !== service_description12
        ) {
            quillInstance.current.clipboard.dangerouslyPasteHTML(service_description12);
        }
    }, [service_description12]);

    return (
        <div className="font-poppins overflow-hidden">
            <label
                htmlFor="businessDescription"
                className="block text-sm font-normal mb-2  text-textcolor"
            >
                Meta Description<span className="text-[#FF0000]"> *</span>
            </label>
            <div
                ref={editorRef}
            />
        </div>

    );
}

export default AddStoreMetaDescription;
