import React, { useRef, useState, useEffect } from "react";
import crossicon from "../../../assets/Images/cross.png";
import uploadicon from "../../../assets/Images/upload.png";
import { useDispatch } from "react-redux";
import toast from "react-hot-toast";
import { useAppSelector } from "../../../Hooks/Hooks";
import { removeCoverImageByIndex, updateAddserviceImages } from "../../../Appstore/Slice/UploadAddserviceImageSlice";


function StoreImage() {
    const coverImages = useAppSelector((state) => state.UploadAddserviceImageSlice.cover_images);
    const dispatch = useDispatch();
    const fileInputRef = useRef<HTMLInputElement>(null);
    const [previewImages, setPreviewImages] = useState<string[]>([]);

    useEffect(() => {
        const urls = coverImages.map((file) => URL.createObjectURL(file));
        setPreviewImages(urls);

        return () => {
            urls.forEach((url) => URL.revokeObjectURL(url));
        };
    }, [coverImages]);

    const handleFileClick = () => {
        fileInputRef.current?.click();
    };

    const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const files = e.target.files;
        if (!files || files.length === 0) return;

        const validImages = Array.from(files).filter((file) =>
            file.type.startsWith("image/")
        );

        if (validImages.length !== files.length) {
            toast.error("Only image files are allowed.");
            return;
        }

        dispatch(updateAddserviceImages(validImages));
    };

    const handleRemoveFile = (index: number) => {
        dispatch(removeCoverImageByIndex(index));
    };

    return (
        <div className="overflow-hidden h-fit">
            <div>
                <label className="font-poppins text-sm font-medium text-textcolor">
                    Store Images  <span className=" text-[#808080]  text-[13px]  font-poppins">(Multiple images can be uploaded)</span>
                    <span className="text-[#F21818] pl-[1px]">*</span>
                </label>

                <div
                    className="font-poppins mt-2 flex h-[2.8rem] w-full border border-bordercolor cursor-pointer items-center justify-center rounded-lg p-3 borderinputbox"
                    onClick={handleFileClick}
                >
                    <input
                        type="file"
                        accept="image/*"
                        multiple
                        ref={fileInputRef}
                        onChange={handleFileChange}
                        className="hidden"
                    />
                    <div className="flex w-full gap-3 items-center justify-center">
                        <img src={uploadicon} alt="upload icon" className="h-4 w-4 object-cover" />
                        <p className="font-poppins text-[#B4B4B4] font-medium text-sm text-center">
                            Drop your images here or click to browse
                        </p>
                    </div>
                </div>

                {previewImages.length > 0 && (
                    <div className="w-full h-fit mt-2 pt-4 flex flex-wrap gap-4">
                        {previewImages.map((img, index) => (
                            <div key={index} className="relative flex items-center justify-center">
                                <div className="relative">
                                    <img
                                        src={img}
                                        alt={`Uploaded preview ${index}`}
                                        className="uploadimageborder rounded-md object-cover w-[80px] h-[80px]"
                                    />
                                    <button
                                        type="button"
                                        className="absolute right-[-0.2rem] top-0"
                                        onClick={() => handleRemoveFile(index)}
                                    >
                                        <div className="flex h-6 w-6 items-center justify-center rounded-full bg-[#BABABA]">
                                            <img src={crossicon} alt="cross icon" className="h-4 w-4 object-cover" />
                                        </div>
                                    </button>
                                </div>
                            </div>
                        ))}
                    </div>
                )}
            </div>
        </div>
    );
}

export default StoreImage;
