"use client";
import React from "react";
import FormGlobalINputNlytical from "../../../Componets/Form/FormGlobalINputNlytical";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { updateAddPostData } from "../../../Appstore/Slice/Storevalues/AddStoreSlice";
import toast from "react-hot-toast";
import PhoneNumber from "./PhoneNUmber";

function ContactDetails() {
  const dispatch = useAppDispatch();
  const formData = useAppSelector((state) => state.AddStoreSlice);

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    const { name, value } = e.target;
    dispatch(updateAddPostData({ [name]: value }));
  };

  const handleNextStep = () => {
    if (!formData.service_phone || !formData.service_email) {
      toast.error("Phone number and Email are required.");
      return;
    }

    if ((formData.add_new_post_steps ?? 0) < 3) {
      dispatch(
        updateAddPostData({
          add_new_post_steps: ((formData.add_new_post_steps ?? 0) + 1) as 1 | 2 | 3,
        })
      );
    }
  };

  const handlePreviousStep = () => {
    if ((formData.add_new_post_steps ?? 0) > 1) {
      dispatch(
        updateAddPostData({
          add_new_post_steps: ((formData.add_new_post_steps ?? 0) - 1) as 1 | 2 | 3,
        })
      );
    }
  };

  return (
    <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid md:grid-cols-2 gap-4">

        <PhoneNumber />

        <FormGlobalINputNlytical
          label="Email"
          labeloptionalvalues="Ex: support@example.com"
          name="service_email"
          value={formData.service_email || ""}
          onChange={handleChange}
          required
          placeholder="Enter Email"
        />
        <FormGlobalINputNlytical
          label="Website"
          labeloptionalvalues="Ex: https://www.example.com"
          name="service_website"
          value={formData.service_website || ""}
          onChange={handleChange}
          placeholder="Enter Web Link"
        />
        <FormGlobalINputNlytical
          label="Facebook"
          labeloptionalvalues="Ex: https://www.example.com"
          name="facebook_link"
          value={formData.facebook_link || ""}
          onChange={handleChange}
          placeholder="Enter Facebook Link"
        />
        <FormGlobalINputNlytical
          label="WhatsApp"
          labeloptionalvalues="Ex: https://wa.me/1234567890"
          name="whatsapp_link"
          value={formData.whatsapp_link || ""}
          onChange={handleChange}
          placeholder="Enter WhatsApp Link"
        />
        <FormGlobalINputNlytical
          label="Instagram"
          labeloptionalvalues="Ex: https://www.instagram.com/example"
          name="instagram_link"
          value={formData.instagram_link || ""}
          onChange={handleChange}
          placeholder="Enter Instagram Link"
        />
        <FormGlobalINputNlytical
          label="Twitter"
          labeloptionalvalues="Ex: https://twitter.com/example"
          name="twitter_link"
          value={formData.twitter_link || ""}
          onChange={handleChange}
          placeholder="Enter Twitter Link"
        />
      </div>

      <div className="w-full flex justify-center gap-9 items-center">
        <button
          className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white"
          onClick={handlePreviousStep}
        >
          Previous
        </button>
        <button
          className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white"
          onClick={handleNextStep}
        >
          Next
        </button>
      </div>
    </div>
  );
}

export default ContactDetails;
