import React, { useEffect, useState } from "react";
import { MdOutlineChevronRight } from "react-icons/md";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { updateAddPostData } from "../../../Appstore/Slice/Storevalues/AddStoreSlice";

// Generate years from 2000 to 2050
const years = Array.from({ length: 51 }, (_, i) => 2000 + i);

function YearDropdown() {
  const dispatch = useAppDispatch();
  const selectedYearFromStore = useAppSelector(
    (state) => state.AddStoreSlice.published_year
  );

  const [selectedYear, setSelectedYear] = useState("");
  const [searchValue, setSearchValue] = useState("");
  const [showDropdown, setShowDropdown] = useState(false);
  const [rotate, setRotate] = useState(false);

  useEffect(() => {
    if (selectedYearFromStore) {
      setSelectedYear(selectedYearFromStore);
      setSearchValue(selectedYearFromStore);
    }
  }, [selectedYearFromStore]);

  const handleToggle = () => {
    setShowDropdown((prev) => !prev);
    setRotate((prev) => !prev);
  };

  const handleBlur = () => {
    setTimeout(() => {
      setShowDropdown(false);
      setRotate(false);
    }, 150);
  };

  const handleSelectYear = (year: number) => {
    const yearStr = year.toString();
    setSelectedYear(yearStr);
    setSearchValue(yearStr);
    dispatch(updateAddPostData({ published_year: yearStr }));
    setShowDropdown(false);
    setRotate(false);
  };

  const filteredYears = years.filter((year) =>
    year.toString().includes(searchValue)
  );

  return (
    <div className="w-full flex flex-col relative h-full">
      <label htmlFor="close-time" className="font-poppins text-sm font-medium text-textcolor">
        Year <span className="text-[#F21818] pl-[1px]">*</span>
      </label>

      <div className="relative mt-1 flex items-center cursor-pointer">
        <input
          type="text"
          id="year"
          value={searchValue}
          placeholder="Search or select year"
          onChange={(e) => {
            const val = e.target.value;
            setSearchValue(val);
            if (val === "") {
              // clear the slice value when input is cleared
              dispatch(updateAddPostData({ published_year: "" }));
            }
          }}


          onFocus={() => {
            setShowDropdown(true);
            setRotate(true);
          }}
          onBlur={handleBlur}
          className="w-full rounded-lg border border-bordercolor cursor-pointer focus:border-blue-500 text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
        />
        <div
          className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
          onClick={handleToggle}
        >
          <MdOutlineChevronRight />
        </div>
      </div>

      {showDropdown && (
        <ul className="absolute top-[5rem] left-0 w-full bg-white text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
          {filteredYears.length > 0 ? (
            filteredYears.map((year) => (
              <li
                key={year}
                className="px-4 py-2 font-poppins text-sm hover:bg-gray-100 cursor-pointer"
                onMouseDown={() => handleSelectYear(year)}
              >
                {year}
              </li>
            ))
          ) : (
            <li className="px-4 py-2 text-center text-gray-500 font-poppins text-sm">
              No matching year
            </li>
          )}
        </ul>
      )}
    </div>
  );
}

export default YearDropdown;
