import React from "react";
import { useDispatch } from "react-redux";
import { useAppSelector } from "../../../Hooks/Hooks";
import { updateAddPostData } from "../../../Appstore/Slice/Storevalues/AddStoreSlice";

function TotalMember() {
    const dispatch = useDispatch();
    const selectedValue = useAppSelector((state) => state.AddStoreSlice.employee_strength);

    const options = [
        { label: "Less than 10", value: "Less than 10" },
        { label: "10-100", value: "10-100" },
        { label: "100-500", value: "100-500" },
        { label: "500-1000", value: "500-1000" },
        { label: "1000-2000", value: "1000-2000" },
        { label: "2000-5000", value: "2000-5000" },
        { label: "5000-10000", value: "5000-10000" },
        { label: "More than 10000", value: "More than 10000" },
    ];

    const handleChange = (e: React.ChangeEvent<HTMLSelectElement>) => {
        dispatch(updateAddPostData({ employee_strength: e.target.value }));
    };

    return (
        <div className="flex flex-col gap-1">
            <label className="font-poppins text-sm font-normal text-textcolor">
                Total Members
                <span className="text-[#F21818] pl-[1px]">*</span>
            </label>
            <select
                name="employee_strength"
                value={selectedValue || ""}
                onChange={handleChange}
                className="w-full rounded-lg border cursor-pointer border-bordercolor focus:border-toggalbtcolorborder text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
            >
                <option value="">Select Total No Of Members</option>
                {options.map((opt) => (
                    <option key={opt.value} value={opt.value}>
                        {opt.label}
                    </option>
                ))}
            </select>
        </div>
    );
}

export default TotalMember;
