import React from "react";
import { useDispatch } from "react-redux";
import { useAppSelector } from "../../../Hooks/Hooks";
import FormGlobalINputNlytical from "../../../Componets/Form/FormGlobalINputNlytical";
import Vendordropdwon from "./Vendordropdwon";
import CategorylistInput from "../../../Componets/AllModals/AddSubCategoryModal/CategorylistInput";
import SubCategoryDropdwon from "./SubCategoryDropdwon";
import GoogleMapLocation from "../../../Componets/GoogleMapLocation/GoogleMapLocation";
import TotalMenber from "./TotalMenber";
import { updateAddPostData } from "../../../Appstore/Slice/Storevalues/AddStoreSlice";
import StoreDescription from "./StoreDescription";
import toast from "react-hot-toast";
import StoreDescriptionTextEditNewV from "./StoreDescriptionTextEditNewV";

function BusinessInfo() {
    const dispatch = useDispatch();
    const formData = useAppSelector((state) => state.AddStoreSlice);
    const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
        const { name, value } = e.target;
        dispatch(updateAddPostData({ [name]: value }));
    };



    console.log("formDataformDataadd slice values", formData.service_name, formData.service_address, formData.address, formData.area, formData.city, formData.state, formData.employee_strength)
    const vendors = useAppSelector((state) => state.vendor.selectedVendor)
    const selectedCategory = useAppSelector((state) => state.category.selectedCategory);
    const { service_description } = useAppSelector((state) => state.StoreaddDescription)



    const location = useAppSelector((state) => state.CurrentLocationSlice);
    const selectedlocation = useAppSelector((state) => state.location);

    // Store values in variables
    const currentLocation: string | undefined = location?.locationName;
    const userSelectedLocation: string | undefined = selectedlocation?.selectedLocation;

    // Final value: prefer selected location if it exists, else current location
    const finalLocation: string | undefined = userSelectedLocation || currentLocation;

    // Log only once based on conditions
    const logMessage: string = userSelectedLocation
        ? `📍 User selected location: ${userSelectedLocation}`
        : currentLocation
            ? `📍 Default current location: ${currentLocation}`
            : "⚠️ No location available";

    console.log(logMessage);
    console.log("✅ Final location being used:", finalLocation);


    const handalnextbtn = () => {
        const requiredFields = [
            { name: "Service Name", value: formData.service_name },
            // { name: "Service Address", value: formData.service_address },
            { name: "Address", value: formData.address },
            { name: "Area", value: formData.area },
            { name: "City", value: formData.city },
            { name: "State", value: formData.state },
            { name: "Employee Strength", value: formData.employee_strength },
            { name: "Service Description", value: service_description },
            { name: "Category", value: selectedCategory },
            { name: "Vendors", value: vendors },
        ];

        const firstMissingField = requiredFields.find(
            field => !field.value || field.value === ''
        );

        if (firstMissingField) {
            toast.error(`Please fill in the required field: ${firstMissingField.name}`);
            return;
        }

        dispatch(
            updateAddPostData({
                add_new_post_steps: ((formData.add_new_post_steps || 1) + 1) as 1 | 2 | 3,
            })
        );
    };




    console.log(" my step values!!@", formData.add_new_post_steps)

    return (
        <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
            <div className="w-full h-fit grid md:grid-cols-2 gap-4">
                {/* Store Name */}
                <FormGlobalINputNlytical label="Store Name" name="service_name" value={formData.service_name || ""} onChange={handleChange} required placeholder="Enter Store Name" />

                {/* Vendor, Category, SubCategory */}
                <Vendordropdwon />
                <CategorylistInput />
                <SubCategoryDropdwon />
                {/* <StoreDescription /> */}
                <StoreDescriptionTextEditNewV/>
                {/* Google Map Location */}
                <GoogleMapLocation />

                {/* Address Details */}
                {/* <FormGlobalINputNlytical
                    label="Store Location"
                    labeloptionalvalues="Based on your Google Maps location"
                    name="service_address"
                    value={finalLocation || ""}
                    onChange={() => { }}
                    required
                    placeholder="Enter store location"
                /> */}
                <FormGlobalINputNlytical label="Address (House No, Building, Street)" name="address" value={formData.address || ""} onChange={handleChange} required placeholder="Enter Full Address" />
                <FormGlobalINputNlytical label="Area" name="area" value={formData.area || ""} onChange={handleChange} required placeholder="Enter Area" />
                <FormGlobalINputNlytical label="City" name="city" value={formData.city || ""} onChange={handleChange} required placeholder="Enter City" />
                <FormGlobalINputNlytical label="State" name="state" value={formData.state || ""} onChange={handleChange} required placeholder="Enter State" />

                {/* Total Member */}
                <TotalMenber />
            </div>

            {/* NEXT Button */}
            <div className="w-full flex justify-center items-center">
                <button className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white" onClick={handalnextbtn} >Next</button>
            </div>
        </div>
    );
}

export default BusinessInfo;
