import React, { useRef, useState, useEffect } from "react";
import crossicon from "../../assets/Images/cross.png";
import uploadicon from "../../assets/Images/upload.png";
import pdficon from "../../assets/Images/pdficon.png";
import wordicon from "../../assets/Images/pdficon.png";
import fileicon from "../../assets/Images/pdficon.png";

import { useDispatch } from "react-redux";
import toast from "react-hot-toast";
import { useAppSelector } from "../../Hooks/Hooks";
import { updateAddserviceAttactmentImage } from "../../Appstore/Slice/UploadServiceAttactmentSlice";

function ServiceAttachment() {
    const coverImage = useAppSelector((state) => state.UploadServiceAttactmentSlice.cover_image);
    const dispatch = useDispatch();
    const fileInputRef = useRef<HTMLInputElement>(null);
    const [fileName, setFileName] = useState<string | null>(null);
    const [fileIcon, setFileIcon] = useState<string | null>(null);

    useEffect(() => {
        if (coverImage) {
            setFileName(coverImage.name);

            const fileType = coverImage.name.split(".").pop()?.toLowerCase();
            switch (fileType) {
                case "pdf":
                    setFileIcon(pdficon);
                    break;
                case "doc":
                case "docx":
                    setFileIcon(wordicon);
                    break;
                default:
                    setFileIcon(fileicon);
                    break;
            }
        } else {
            setFileName(null);
            setFileIcon(null);
        }
    }, [coverImage]);

    const handleFileClick = () => {
        fileInputRef.current?.click();
    };

    const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const files = e.target.files;
        if (!files || files.length === 0) return;

        if (files.length > 1) {
            toast.error("You can only upload one file at a time.");
            return;
        }

        const file = files[0];
        dispatch(updateAddserviceAttactmentImage(file));
    };

    const handleRemoveFile = () => {
        dispatch(updateAddserviceAttactmentImage(null));
    };

    return (
        <div className="overflow-hidden h-fit">
            <div>
                <label htmlFor="attachment" className="font-poppins text-sm font-medium text-textcolor">
                    Service Attachment
                    {/* <span className="text-[#F21818] pl-[1px]">*</span> */}
                </label>

                <div
                    className="font-poppins mt-2 flex h-[2.8rem] w-full border border-bordercolor cursor-pointer items-center justify-center rounded-lg p-3 borderinputbox"
                    onClick={handleFileClick}
                >
                    <input
                        type="file"
                        accept=".pdf,.doc,.docx,.txt,.xls,.xlsx,.ppt,.pptx,.odt"
                        ref={fileInputRef}
                        onChange={handleFileChange}
                        className="hidden"
                    />

                    <div className="flex w-full gap-3 items-center justify-center">
                        <img src={uploadicon} alt="upload icon" className="h-4 w-4 object-cover" />
                        <p className="font-poppins text-[#B4B4B4] font-medium text-sm text-center">
                            Drop your file here or click to browse
                        </p>
                    </div>
                </div>

                {fileName && (
                    <div className="w-full h-fit mt-4 pt-2 flex items-center gap-4   ">
                        {fileIcon && <img src={fileIcon} alt="file icon" className="w-10 h-10 object-contain" />}
                        <div className="flex gap-2">
                            <p className="font-poppins text-sm text-gray-700">{fileName}</p>
                            <button
                                type="button"
                                className="flex h-6 w-6 items-center  cursor-pointer justify-center rounded-full bg-[#BABABA]"
                                onClick={handleRemoveFile}
                            >
                                <img src={crossicon} alt="Remove" className="h-4 w-4 object-cover" />
                            </button>
                        </div>

                    </div>
                )}
            </div>
        </div>
    );
}

export default ServiceAttachment;
