import React from "react";

interface UserInfoProps {
    profilePic?: string;
    username: string;
    email: string;
    mobile: string;
    onClick: () => void;
}

const TableUserInfo: React.FC<UserInfoProps> = ({ profilePic, username, email, mobile, onClick }) => {
    const showInitial = !profilePic || profilePic.trim() === "";

    return (
        <div className="w-full flex gap-2 items-center cursor-pointer" onClick={onClick}>
            {showInitial ? (
                <div className="w-12 h-12 rounded-full bg-[#0046AE75] flex items-center justify-center text-black font-bold text-base">
                    {username?.[0]?.toUpperCase() || ""}
                </div>
            ) : (
                <div
                    className="w-12 h-12 rounded-full"
                    style={{
                        backgroundImage: `url(${profilePic})`,
                        backgroundSize: "cover",
                        backgroundPosition: "center",
                    }}
                />
            )}
            <div>
                <h2 className="text-textcolor font-poppins text-sm font-semibold">
                    {username}
                </h2>
                <p className="text-xs text-[#939393] dark:text-tableDarkLarge light:text-tableLightLarge font-poppins">
                    {email === "" ? mobile : email}
                </p>
            </div>
        </div>
    );
};

export default TableUserInfo;
