import { NavLink, useNavigate } from "react-router-dom";
import { useSelector, useDispatch } from "react-redux";
import { MdKeyboardArrowLeft } from "react-icons/md";
import Cookies from "js-cookie";
import Snapta from "../../assets/Images/logo.png";
import Dashboard1 from "../../assets/Images/dashboard1.png";
import Dashboard2 from "../../assets/Images/dashboard2.png";
import PostList1 from "../../assets/Images/Reel.png";
import PostList2 from "../../assets/Images/relld.png";
import PostListh from "../../assets/Images/PostListh.png";
import StoriesList1 from "../../assets/Images/gift.png";
import StoriesList2 from "../../assets/Images/giftd.png";
import StoriesListh from "../../assets/Images/StoriesListh.png";
import giftc from "../../assets/Images/giftc.png";
import giftcd from "../../assets/Images/giftcd.png";
import ReportList1 from "../../assets/Images/ReportList1.png";
import ReportList2 from "../../assets/Images/ReportList2.png";
import UserList1 from "../../assets/Images/UserList1.png";
import UserList2 from "../../assets/Images/UserList2.png";
import CountryWise1 from "../../assets/Images/CountryWise1.png";
import CountryWise2 from "../../assets/Images/CountryWise2.png";
import CountryWiseh from "../../assets/Images/Flagh.png";
import HashtagList1 from "../../assets/Images/HashtagList1.png";
import HashtagList2 from "../../assets/Images/HashtagList2.png";
import HashtagListh from "../../assets/Images/HashtagListh.png";
import LanguageList1 from "../../assets/Images/LanguageList1.png";
import LanguageList2 from "../../assets/Images/LanguageList2.png";
import LanguageListh from "../../assets/Images/LanguageListh.png";
import BlockList1 from "../../assets/Images/BlockList1.png";
import BlockList2 from "../../assets/Images/BlockList2.png";
import BlockListh from "../../assets/Images/BlockListh.png";
import AvatarList1 from "../../assets/Images/empty-wallet.png";
import AvatarList3 from "../../assets/Images/empty-wallet1.png";
import AvatarList2 from "../../assets/Images/empty-walletd.png";
import Settings1 from "../../assets/Images/settings1.png";
import Settings2 from "../../assets/Images/settings2.png";
import Settingsh from "../../assets/Images/Settingsh.png";
import cms1 from "../../assets/Images/cms1.png";
import cms3 from "../../assets/Images/cms3.png";
import cms2 from "../../assets/Images/cms2.png";
import cmsh from "../../assets/Images/cmsh.png";
import R2l from "../../assets/Images/R2l.png";
import R2d from "../../assets/Images/R2d.png";
import Ml from "../../assets/Images/muscil.png";
import Md from "../../assets/Images/muscid.png";
import ll from "../../assets/Images/ml.png";
import ld from "../../assets/Images/md.png";
import Arrow from "../../assets/Images/Arrow.png";
import AAA from "../../assets/Images/nly.png"
import Currenc from "../../assets/Images/Currency.png"
import front from "../../assets/Images/front.png"
import feed from "../../assets/Images/feed.png"
import setting12 from "../../assets/Images/setting21.png"
import payment from "../../assets/Images/payment.png"
import payment12 from "../../assets/Images/payment12.png"
import { toggleSidebar } from "../../Appstore/Slice/sidebarSlice";
import landark from "../../assets/Images/landark.png"
import lan from "../../assets/Images/lanlight.png"
import { useState } from "react";
import { useAppDispatch } from "../../Hooks/Hooks";
import { showModal } from "../../Appstore/Slice/ModalSlice";
import { reset } from "../../Appstore/Slice/toggleSlice";
import { clearCoverImage } from "../../Appstore/Slice/AddImageSlice";
import { clearCoverImageCategoryIcon } from "../../Appstore/Slice/CategoryIconSlice";
import { clearSelectedCategory } from "../../Appstore/Slice/CategorySelectedIDandValues";
import { resetall } from "../../Appstore/Slice/AddVendorSlice";
import { clearAddPostData } from "../../Appstore/Slice/Storevalues/AddStoreSlice";
import { clearVendordetail } from "../../Appstore/Slice/VendorSlice";
import { resetSubCategoryState } from "../../Appstore/Slice/SubCategorySlice";
import { clearall } from "../../Appstore/Slice/Storevalues/StoreaddDescription";
import { resetDays } from "../../Appstore/Slice/Storevalues/OpenDaySlice";
import { clearCoverImageatc } from "../../Appstore/Slice/UploadServiceAttactmentSlice";
import { clearAllCoverImages } from "../../Appstore/Slice/UploadAddserviceImageSlice";
import { clearall12 } from "../../Appstore/Slice/AddSubcriptionDescription";
import toast from "react-hot-toast";
import { UseGetGeneralSetting } from "../../Appstore/Api/UseGetGeneralSetting";

const options1 = [
    {
        name: "DASHBOARD",
        subOptions: [{ name: "Dashboard", path: "/dashboard", src: Dashboard2, src1: Dashboard1 }],
    },
    {
        name: "User Management",
        src: ReportList1,
        src1: ReportList2,

        subOptions: [
            { name: "All Users", path: "/alluser-list", src: UserList2, src1: UserList1, srch: PostListh },
            { name: "Customer List", path: "/customer-list", src: cms3, src1: cms1, srch: StoriesListh },
            {
                name: "Vendor",
                src: PostList1,
                src1: ld,
                sub: [
                    { name: "Vendor List", path: "/Vendor-List" },
                    { name: "Add Vendor", path: "/add-vendor" },
                ],
            },


        ],
    },



    {
        name: "Service Management",
        src: ReportList1,
        src1: ReportList2,
        subOptions: [
            {
                name: "Store",
                src: CountryWiseh,
                src1: StoriesList1,
                sub: [
                    { name: "Store List", path: "/store-list" },
                    { name: "Add Store", path: "" },
                ],
            },
            {
                name: "Service",
                src: Settings1,
                src1: Settingsh,
                sub: [
                    { name: "Service List", path: "/service-list" },
                    { name: "Add Service", path: "/add-service" },
                ],
            },
            {
                name: "Category",
                src: CountryWise2,
                src1: CountryWise1,
                sub: [
                    { name: "Category List", path: "/category-list" },
                    { name: "Add Category", path: "" },
                ],
            },

            {
                name: " Sub Category ",
                src: BlockList2,
                src1: BlockList1,
                sub: [
                    { name: "Sub Category List", path: "/subcategory-list" },
                    { name: "Add Sub Category", path: "" },
                ],
            },
            { name: "Reviews", path: "/review-list", src: AvatarList3, src1: AvatarList1, srch: StoriesListh },
        ],
    },

    {
        name: "Subscriptions",
        src: ReportList1,
        src1: ReportList2,
        subOptions: [

            {
                name: "Subscription Plan",
                src: Settings2,
                src1: ll,
                sub: [
                    { name: "Subscription Plan List", path: "/subscription-list" },
                    { name: "Add Subscription Plan", path: "" },
                ],
            },
            { name: "Subscribed Vendor", path: "/subscribed-vendor", src: LanguageListh, src1: HashtagList1, srch: PostListh },
        ],
    },

    {
        name: "SPONSOR",
        src: ReportList1,
        src1: ReportList2,
        subOptions: [{ name: "Sponsor List ", path: "/sponsor-list", src: HashtagListh, src1: HashtagList2, srch: StoriesListh }],
    },

    {
        name: "Marketing & Advertising",
        src: ReportList1,
        src1: ReportList2,
        subOptions: [
            {
                name: "Slider",
                src: LanguageList1,
                src1: cms2,
                sub: [
                    { name: "Slider List", path: "/slider-list" },
                    { name: "Add Slider", path: "" },
                ],
            },
        ],
    },

    {
        name: "Content Management",
        src: ReportList1,
        src1: ReportList2,
        subOptions: [
            {
                name: "Page",
                src: LanguageList2,
                src1: cmsh,
                sub: [
                    { name: "Privacy Policy", path: "/privacy-policy" },
                    { name: "Terms & Conditions", path: "/termsconditions" },
                    { name: "Refund Policy", path: "/refund-policy" },
                    { name: "Cancellation Policy", path: "/cancellation-policy" },
                    { name: "About", path: "/about" },
                    { name: "Contact Us", path: "/contact-us" },
                ],
            },


            {
                name: "FAQ's",
                src: PostList2,
                src1: AvatarList2,
                sub: [
                    { name: "FAQ's List", path: "/faq-list" },
                    { name: "Add FAQ's", path: "" },
                ],
            },


            {
                name: "Report Text",
                src: giftc,
                src1: BlockListh,
                sub: [
                    { name: "Report Text List", path: "/report-text" },
                    { name: "Add Report Text", path: "" },
                ],
            },

            {
                name: "Testimonials",
                src: AAA,
                src1: giftcd,
                sub: [
                    { name: "Testimonials List", path: "/testimonials-list" },
                    { name: "Add Testimonials", path: "" },
                ],
            },


            {
                name: "Language",
                src: lan,
                src1: landark,
                sub: [
                    { name: "Language List", path: "/language-list" },
                    { name: "Add Language", path: "" },
                ],
            },
        ],
    },

    {
        name: "Financial Management",
        src: ReportList1,
        src1: ReportList2,
        subOptions: [
            {
                name: "Currencies",
                src: Currenc,
                src1: R2l,
                sub: [
                    { name: "Currencies List", path: "/currencies-list" },
                    { name: "Add Currencies", path: "" },
                ],
            },
        ],
    },

    {
        name: "Settings Management",
        src: ReportList1,
        src1: ReportList2,

        subOptions: [
            { name: "Front End", path: "/front-end", src: front, src1: R2d, srch: StoriesListh },
            // {
            //     name: "Feedbacks",
            //     src: feed,
            //     src1: Ml,
            //     sub: [
            //         { name: "App Feedback", path: "/app-feedback" },
            //         { name: "Customer Support", path: "/customer-support" },
            //         { name: "News Letter  Email", path: "/subscribed-email" },
            //     ],
            // },

            { name: "App Feedback", path: "/app-feedback", src: feed, src1: Ml, srch: StoriesListh },
            { name: "Customer Support", path: "/customer-support", src: feed, src1: Ml, srch: StoriesListh },
            { name: "News Letter  Email", path: "/subscribed-email", src: feed, src1: Ml, srch: StoriesListh },
            { name: "Payment Method", path: "/payment-method", src: payment, src1: payment12, srch: StoriesListh },

        ],
    },

    {
        name: "Mobile Setting",
        subOptions: [{ name: "Settings", path: "/settings", src: setting12, src1: Md }],
    },
];

interface SidebarProps {
    isOpen: boolean;
    onClose: () => void;
}

function Sidebar({ }: SidebarProps) {
    const dispatch = useDispatch();
    const isSidebarOpen = useSelector((state: { sidebar: { isOpen: boolean } }) => state.sidebar.isOpen);



    //    when is_payment false then hide else show


    const { data } = UseGetGeneralSetting();
    const is_payment = data?.data?.is_payment;

    // Filtered options based on is_payment
    const filteredOptions = options1.map(section => {
        // Clone the section to avoid mutation
        const newSection = { ...section };

        // Filter logic for specific items when is_payment is false
        if (!is_payment) {
            newSection.subOptions = section.subOptions.filter(item => {
                const isSubscriptionPlan = item.name === "Subscription Plan";
                const isSubscribedVendor = item.name === "Subscribed Vendor";
                const isSponsorList = item.name === "Sponsor List ";
                const isPaymentMethod = item.name === "Payment Method";

                return !(
                    isSubscriptionPlan ||
                    isSubscribedVendor ||
                    isSponsorList ||
                    isPaymentMethod
                );
            });
        }

        return newSection;
    }).filter(section => section.subOptions.length > 0); // Remove sections with no visible subOptions



    console.log("is_paymentis_paymentis_paymentis_payment", is_payment)

    const handleSidebar = () => {
        dispatch(toggleSidebar());
    };

    const [openSubMenu, setOpenSubMenu] = useState(null);

    const toggleSubMenu = (name) => {
        setOpenSubMenu(openSubMenu === name ? null : name);
    };

    const handleRemove = () => {
        Cookies.remove("userId");
    };

    const onClose = () => {
        dispatch(toggleSidebar());
    };


    // handalopenmodal


    const navigator = useNavigate()



    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handalopenmodal = (item: any) => {



        if (item.name == "Add Category") {
            dispatch(showModal("AddCategoryModal"))
            dispatch(reset())
            dispatch(clearCoverImage())
            dispatch(clearCoverImageCategoryIcon())
        }
        else if (item.name == "Add Sub Category") {
            dispatch(showModal("AddSubCategoryModal"))
            dispatch(reset())
            dispatch(clearCoverImage())
            dispatch(clearSelectedCategory())
        }

        else if (item.name == "Add Subscription Plan") {
            navigator("/subscription-list")
        }

        else if (item.name == "Add Slider") {
            dispatch(showModal("AddSliderModal"));
            dispatch(clearCoverImage());
            dispatch(resetall());
            dispatch(reset())
        }

        else if (item.name == "Add FAQ's") {
            dispatch(showModal("AddFAQModal"))
            dispatch(reset())
        }

        else if (item.name == "Add Report Text") {
            dispatch(showModal("AddReportTextModal"))
            dispatch(reset())
        }

        else if (item.name == "Add Testimonials") {
            dispatch(showModal("AddClientReviewModal"))
            dispatch(reset())
            dispatch(clearCoverImage())
        }


        else if (item.name == "Add Language") {
            dispatch(showModal("AddLanguage_Modal"))
            dispatch(reset())
        }

        else if (item.name == "Add Currencies") {
            dispatch(showModal("AddCurrencyModal"))
            dispatch(reset())
            dispatch(clearCoverImage())
        }
        else if (item.name == "Add Store") {
            dispatch(clearAddPostData())
            dispatch(clearVendordetail())
            dispatch(clearSelectedCategory())
            dispatch(resetSubCategoryState())
            dispatch(clearall())
            dispatch(resetDays())
            dispatch(clearCoverImageatc())
            dispatch(clearAllCoverImages())
            dispatch(clearall12())
            navigator("/add-store")

        }
        else {
            return;
        }






    }



    return (
        <div className={`transition-all duration-300 h-screen ${isSidebarOpen ? "w-20" : "xl:w-72"} text-[#5B5B5B] left-0 top-0 z-50 bg-primary  flex flex-col gap-10 fixed border border-bordercolortop`}>
            <div className="flex flex-col h-full">
                {/* Top Section: Logo & Toggle Arrow */}
                <div className="flex items-center justify-between px-6 pt-8">
                    <div className="flex items-center gap-2">
                        {/* <img src={logo} className="w-8 h-8" /> */}
                        {!isSidebarOpen && <img src={Snapta} alt="snapta" className="w-[75px]" />}
                    </div>
                    {/* Arrow */}
                    <div className="absolute z-50 -right-3 top-4">
                        <MdKeyboardArrowLeft className={`w-6 h-6 cursor-pointer bg-[#5b5b5b70] xl:block hidden transition-transform duration-300 ${isSidebarOpen ? "" : "rotate-180"}`} onClick={handleSidebar} />
                    </div>
                    {/* Mobile close button */}
                    <button onClick={onClose} className="absolute text-2xl text-gray-600 top-4 right-4 xl:hidden">
                        ×
                    </button>
                </div>

                {/* Scrollable Menu Section */}
                <div className="flex-1 pr-1 mt-6 overflow-y-auto custom-scrollbar">
                    <div className="space-y-3">
                        {filteredOptions.map((section, index) => (
                            <div key={section.name}>
                                {!isSidebarOpen && <div className="px-6 pb-3 text-base font-semibold tracking-wide text-textcolor text-opacity-[53%]">{section.name} </div>}

                                {/* Section Items */}
                                {section.subOptions.map((item, index) => {
                                    return (
                                        <div key={item.name} className="relative ml-2">
                                            {/* Main Option (with nested sub if exists) */}
                                            <div className="left-0 flex items-center justify-between w-full px-6 py-3 transition-all duration-200 cursor-pointer" onClick={() => (item.sub ? toggleSubMenu(item.name) : null)}>
                                                {item.sub ? (
                                                    <div className="flex items-center w-full">
                                                        <img src={item.src} className="w-5 h-5" alt={item.name} />
                                                        <span className={`ml-3 text-sm font-poppins text-sidebartextcolor ${isSidebarOpen ? "hidden" : ""}`}>{item.name} </span>
                                                    </div>
                                                ) : (
                                                    <NavLink to={item.path} className={({ isActive }) => `flex items-center w-full ${isActive ? "text-transparent bg-clip-text bg-header font-semibold" : ""}`} onClick={handleRemove}>
                                                        {({ isActive }) => (
                                                            <div className="flex items-center  ">
                                                                {isActive && (
                                                                    <div className="absolute w-1 h-5 rounded-r -left-2 top-3 bottom-3 bg-header" /> //for the left line of active button
                                                                )}

                                                                <div className="relative w-5 h-5">
                                                                    <img src={isActive ? item.src1 : item.src} className="w-5 h-5 dark:group-hover:hidden" alt="default" />
                                                                    <img src={isActive ? item.src1 : item.srch} className="absolute top-0 left-0 hidden w-5 h-5 dark:group-hover:block" alt="hover" />
                                                                </div>

                                                                <span className={`ml-3 text-sm font-poppins ${isActive ? "text-maincolor" : "text-sidebartextcolor"} ${isSidebarOpen ? "hidden" : ""}`}>{item.name} </span>
                                                            </div>
                                                        )}
                                                    </NavLink>
                                                )}

                                                {item.sub && <img src={Arrow} className={`w-4 h-4 transition-transform duration-200 ${openSubMenu === item.name ? "" : "-rotate-90"} ${isSidebarOpen ? "hidden" : ""}`} alt="Toggle Submenu" />}
                                            </div>

                                            {item.sub && openSubMenu === item.name && (
                                                <div className={`relative ml-6 ${isSidebarOpen ? "hidden" : ""}`}>
                                                    <div
                                                        className={`absolute left-2 top-0 w-0.5 bg-gray-300`}
                                                        style={{
                                                            height: `${(item?.sub?.length || 0) * 33}px`, // 40px per item (adjust as per your padding)
                                                        }}
                                                    ></div>

                                                    <div className="pl-4">
                                                        {item.sub.map((subItem) => (
                                                            <div key={subItem.name} className="relative flex items-center">
                                                                <div className="absolute w-4 h-2 border-b-2 border-l-2 border-gray-300 rounded-bl-lg -left-2"></div>
                                                                {subItem.path ? (
                                                                    <NavLink
                                                                        to={subItem.path}
                                                                        className={({ isActive }) =>
                                                                            `flex items-center w-full px-6 py-2 transition-all duration-200 ${isActive ? "text-maincolor font-semibold" : "text-sidebartextcolor"
                                                                            }`
                                                                        }
                                                                        onClick={handleRemove}
                                                                    >
                                                                        <span className={`text-sm font-poppins ${isSidebarOpen ? "hidden" : ""}`}>{subItem.name}</span>
                                                                    </NavLink>
                                                                ) : (
                                                                    <div
                                                                        onClick={() => {
                                                                            handalopenmodal(subItem)
                                                                        }}
                                                                        className="flex items-center w-full px-6 py-2 text-sidebartextcolor transition-all duration-200 cursor-pointer hover:text-maincolor"
                                                                    >
                                                                        <span className={`text-sm font-poppins ${isSidebarOpen ? "hidden" : ""}`}>{subItem.name}</span>
                                                                    </div>
                                                                )}

                                                            </div>
                                                        ))}
                                                    </div>
                                                </div>
                                            )}
                                        </div>
                                    );
                                })}
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        </div>
    );
}

export default Sidebar;
