import React, { useState } from "react";
import { useNavigate } from "react-router-dom";
import Search1 from "../../assets/Images/search.png";
import Logo from "../../assets/Images/SnaptaLogo.png";
import { FaBars } from "react-icons/fa6";
import Sidebar from "../Sidebar/Sidebar";
import AdminProfile from "./AdminProfile";
import { useTheme } from "../../Context/ThemeContext";
import mode from "../../assets/Images/mode.png"
import Moon from "../../assets/Images/moon.png"

const searchOptions = [
    { name: "Dashboard", path: "/dashboard" },
    { name: "AllUser List", path: "/alluser-list" },
    { name: "Customer List", path: "/customer-list" },
    { name: "Vendor List", path: "/Vendor-List" },
    { name: "Category List", path: "/category-list" },
    { name: "Sub Category List", path: "/subcategory-list" },
    { name: "Reviews List", path: "/review-list" },
    { name: "Store List", path: "/store-list" },
    { name: "Service List", path: "/service-list" },
    { name: "Subscription Plan List", path: "/subscription-list" },
    { name: "Subscribed Vendor List", path: "/subscribed-vendor" },
    { name: "Sponsor List", path: "/sponsor-list" },
    { name: "Slider List", path: "/slider-list" },
    { name: "Privacy Policy", path: "/privacy-policy" },
    { name: "Terms & Conditions", path: "/termsconditions" },
    { name: "Refund Policy", path: "/refund-policy" },
    { name: "Cancel Policy", path: "/cancellation-policy" },
    { name: "About", path: "/about" },
    { name: "Contact Us", path: "/contact-us" },
    { name: "Faq List", path: "/faq-list" },
    { name: "Report Text List", path: "/report-text" },
    { name: "Client Reviews List", path: "/testimonials-list" },
    { name: "Language List", path: "/language-list" },
    { name: "Currency List", path: "/currencies-list" },
    { name: "Front End", path: "/front-end" },
    { name: "App Feedback List", path: "/app-feedback" },
    { name: "Customer Support", path: "/customer-support" },
    { name: "News Letter  Email", path: "/subscribed-email" },
    { name: "Payment Method", path: "/payment-method" },
    { name: "Setting", path: "/settings" },

];

function SearchBar() {
    const [search, setSearch] = useState("");
    const navigate = useNavigate();
    const [sidebarOpen, setSidebarOpen] = useState(false);
    const [open, setOpen] = useState(false);

    const filteredOptions = search
        ? searchOptions.filter((option) =>
            option.name.toLowerCase().includes(search.toLowerCase())
        )
        : [];


    const handleOpen = () => {
        setOpen(true);
    };






    // For Theme Toggle 
    const { theme, toggleTheme } = useTheme();


    return (
        <>
            <div className="flex justify-between px-4 relative py-4 border-b border-bordercolortop xl:px-6 2xl:px-6 bg-primary  ">
                {/* Left Section */}
                <div className="flex gap-3">
                    <button onClick={() => setSidebarOpen(!sidebarOpen)}>
                        <FaBars className="w-5 h-5 text-textcolor xl:hidden" />
                    </button>

                    {sidebarOpen && (
                        <Sidebar isOpen={sidebarOpen} onClose={() => setSidebarOpen(false)} />
                    )}

                    <div className="flex justify-center cursor-pointer hidden place-items-center">
                        <img src={Logo} className="w-5 h-5" alt="Logo" />
                    </div>

                    {/* Search Bar */}
                    <div className="sm:relative">
                        <div
                            className="flex items-center py-2 sm:p-2 sm:transform sm:-translate-y-1/2 sm:absolute sm:left-2 sm:top-1/2"
                            onClick={handleOpen}
                        >
                            <img src={Search1} alt="Search" className="w-5 h-5" />
                        </div>

                        <input
                            type="text"
                            className="   border border-bordercolor bg-[#00000005] text-textcolor  rounded-lg w-[350px] py-2 pl-12 placeholder:text-sm placeholder:text-placeholdercolor  xl:block hidden"
                            placeholder="Search"
                            value={search}
                            onChange={(e) => setSearch(e.target.value)}
                        />

                        {search && filteredOptions.length > 0 && (
                            <div className="absolute z-50 w-full mt-1 border border-bordercolor   bg-primary   text-textcolor rounded-lg shadow-md">
                                {filteredOptions.map((option) => (
                                    <p
                                        key={option.name}
                                        onClick={() => navigate(option.path)}
                                        className="px-4 py-2 text-sm cursor-pointer text-textcolor hover:bg-gray-100   dark:hover:text-black"
                                    >
                                        {option.name}
                                    </p>
                                ))}
                            </div>
                        )}
                    </div>
                </div>

                {/* Right Section */}
                <div className="flex gap-4 items-center">

                    <button className="flex items-center  cursor-pointer  p-2 mb-1   lightlogo  rounded-full" onClick={toggleTheme}>
                        {theme === "light" ? (
                            <img className="h-[20px] w-[20px] " src={mode} alt="" />
                        ) : (
                            <img className="h-[20px]  w-[20px]" src={Moon} alt="" />
                        )}
                    </button>

                    <AdminProfile />
                </div>
            </div>
        </>
    );
}

export default SearchBar;
