// src/components/LazyModalWrapper.tsx
import React, { Suspense } from "react";

interface LazyModalWrapperProps {
  condition: boolean;
  Component: React.LazyExoticComponent<() => JSX.Element>;
}

const LazyModalWrapper: React.FC<LazyModalWrapperProps> = ({ condition, Component }) => {
  return condition ? (
    <Suspense fallback={null}>
      <Component />
    </Suspense>
  ) : null;
};

export default LazyModalWrapper;
