"use client";
import { useEffect } from "react";
import { useDispatch } from "react-redux";
import { CiSearch } from "react-icons/ci";
import { useGoogleMaps } from "../../Hooks/useGoogleMaps";
import { setLocation } from "../../Appstore/Slice/locationSlice";
import "./GoogleMapLocationcss.css"
import CurrentLocation from "../CurrentLocation/CurrentLocation";
import { useAppSelector } from "../../Hooks/Hooks";

const GoogleMapLocation = () => {
  const dispatch = useDispatch();
  const googleLoaded = useGoogleMaps();
  const location = useAppSelector((state) => state.CurrentLocationSlice);
  const selectedlocation = useAppSelector((state) => state.location);

  // Store values in variables
  const currentLocation: string | undefined = location?.locationName;
  const userSelectedLocation: string | undefined = selectedlocation?.selectedLocation;

  // Final value: prefer selected location if it exists, else current location
  const finalLocation: string | undefined = userSelectedLocation || currentLocation;

  // Log only once based on conditions
  const logMessage: string = userSelectedLocation
    ? `📍 User selected location: ${userSelectedLocation}`
    : currentLocation
      ? `📍 Default current location: ${currentLocation}`
      : "⚠️ No location available";

  console.log(logMessage);
  console.log("✅ Final location being used:", finalLocation);






  const hasSelectedLocation =
    selectedlocation.lat !== null &&
    selectedlocation.lat !== undefined &&
    selectedlocation.lng !== null &&
    selectedlocation.lng !== undefined;

  // Store in variables
  const finalLat = hasSelectedLocation ? selectedlocation.lat : location.latitude;
  const finalLng = hasSelectedLocation ? selectedlocation.lng : location.longitude;

  console.log("Final latitude and longitude to use:", finalLat, finalLng);



  useEffect(() => {
    if (googleLoaded) {
      initAutocomplete();
    }
  }, [googleLoaded]);

  function initAutocomplete() {
    const input = document.getElementById("pac-input") as HTMLInputElement;
    const mapDiv = document.getElementById("map");

    if (!window.google || !input || !mapDiv) return;

    const lat = parseFloat(location.latitude || "23.0225");
    const lng = parseFloat(location.longitude || "72.5714");

    const map = new google.maps.Map(mapDiv, {
      center: { lat, lng },
      zoom: 13,
      mapTypeId: google.maps.MapTypeId.ROADMAP,
    });

    // DO NOT add input to map.controls, just use SearchBox directly
    const searchBox = new google.maps.places.SearchBox(input);

    let markers: google.maps.Marker[] = [];

    map.addListener("bounds_changed", () => {
      searchBox.setBounds(map.getBounds() as google.maps.LatLngBounds);
    });

    searchBox.addListener("places_changed", () => {
      const places = searchBox.getPlaces();
      if (!places || places.length === 0) return;

      markers.forEach(marker => marker.setMap(null));
      markers = [];

      const bounds = new google.maps.LatLngBounds();

      places.forEach(place => {
        if (!place.geometry || !place.geometry.location) return;

        const marker = new google.maps.Marker({
          map,
          position: place.geometry.location,
          title: place.formatted_address,
        });

        markers.push(marker);

        if (place.geometry.viewport) {
          bounds.union(place.geometry.viewport);
        } else {
          bounds.extend(place.geometry.location);
        }

        const lat = place.geometry.location.lat();
        const lng = place.geometry.location.lng();

        dispatch(
          setLocation({
            name: place.formatted_address || "",
            location: place.geometry.location,
            vicinity: place.name || "",
            lat,
            lng,
          })
        );
      });

      map.fitBounds(bounds);
    });
  }

  return (
    <div className="relative flex h-[25rem] md:h-[20rem] xl:h-full w-full  flex-col rounded-xl">
      {/* Search input absolutely positioned on top center */}
      
      <div className="absolute top-[-0.3rem] left-1/2   w-full -translate-x-1/2">
       <label className="font-poppins text-sm font-normal text-textcolor">
            Store Location
            <span className="text-[#F21818] pl-[1px]">*</span>
          </label>
        <div className="relative w-full">
         
          <input
            id="pac-input"
            className="input-important w-full z-10 rounded-lg border p-4 pl-10 text-sm outline-none shadow-md"
            type="text"
            placeholder="Search for area, street name"
          />
          <CiSearch className="absolute left-3 top-1/2 -translate-y-1/2 transform text-xl text-gray-500" />
        </div>
      </div>

      {/* Map container */}
      <div
        id="map"
        className="flex-1 rounded-xl mt-[5.5rem]"
        style={{ minHeight: "300px", height: "100%", width: "100%" }}
      />

      <div className=" hidden">
        <CurrentLocation />
      </div>
    </div>
  );
};

export default GoogleMapLocation;
