// components/InputField.tsx
import React from 'react';

interface InputFieldProps {
    label: string;
    required?: boolean;
    type?: string;
    placeholder?: string;
    value: string;
    name: string;
    labeloptionalvalues?: string;
    onChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
}

const FormGlobalInputAnalytical: React.FC<InputFieldProps> = ({
    label,
    required = false,
    type = 'text',
    placeholder,
    value,
    name,
    onChange,
    labeloptionalvalues,
}) => {
    return (
        <div className="flex flex-col gap-1">
            <label className="font-poppins text-sm font-normal text-textcolor">
                {label}
                {labeloptionalvalues && (
                    <span className="text-[#808080] text-[13px]"> ({labeloptionalvalues})</span>
                )}
                {required && (
                    <span className="text-[#F21818] pl-[1px]">*</span>
                )}
            </label>
            <input
                type={type}
                name={name}
                value={value}
                placeholder={placeholder}
                onChange={onChange}
                className="w-full rounded-lg border border-bordercolor font-normal focus:border-toggalbtcolorborder text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
            />
        </div>
    );
};

export default FormGlobalInputAnalytical;
