import { Dialog, DialogPanel } from "@headlessui/react";
import toast from "react-hot-toast";
import { useEffect, useState } from "react";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { hideModal } from "../../Appstore/Slice/ModalSlice";
import ModalHeader from "./ModalHeader";
import { setTrue } from "../../Appstore/Slice/toggleSlice";
import AddSubcriptionplandec from "./SubcriptionPlanlListAddModal/AddSubcriptionplandec";
import { updateSubplanData } from "../../Appstore/Slice/AddSubcriptionDescription";
import DurationUpdate from "./DurationUpdate";

function SubscriptionPlanUpdateModal() {
    const isOpen = useAppSelector((state) => state.modals.SubscriptionPlanUpdateModal);
    const { service_description } = useAppSelector((state) => state.AddSubcriptionDescription);
    const dispatch = useAppDispatch();



    console.log("service_descriptionservice_descriptionservice_descriptionservice_description", service_description)



    const { postData, loading, data } = useApiPost();


    //  for get values call the api



    const SubscriptiondUpdate = sessionStorage.getItem("SubscriptiondUpdate")


    useEffect(() => {
        const formdata1 = new FormData()
        formdata1.append("id", SubscriptiondUpdate?.toString() || "")
        postData("/edit-subscription", formdata1)
    }, [SubscriptiondUpdate])


    console.log("api respnce vbalues from update ", data?.subscription)


    const [planName, setPlanName] = useState("");
    const [subText, setSubText] = useState("");
    const [price, setPrice] = useState("");


    useEffect(() => {
        if (data?.subscription) {
            setPlanName(data.subscription.plan_name || "");
            setPrice(data.subscription.price || "");
            setSubText(data.subscription.subtext || "");
            sessionStorage.setItem("DurationName", data.subscription.duration)
            // Update Redux state for description
            dispatch(updateSubplanData({ service_description: data.subscription.description || "" }));
        }
    }, [data]);




    const close = () => dispatch(hideModal("SubscriptionPlanUpdateModal"));




    const duration = useAppSelector((state) => state.addVendor.duration)


    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleSubmit = async () => {


        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        if (!planName || !subText || !price) {
            toast.error("Please fill all required fields");
            return;
        }

        const formData = new FormData();
        formData.append("plan_name", planName);
        formData.append("description", service_description || "");
        formData.append("price", price);
        formData.append("subtext", subText);
        formData.append("id", SubscriptiondUpdate?.toString() || "")
        formData.append("duration", duration)

        try {
            await postData("/edit-subscription", formData, true);
            toast.success("Subscription plan added successfully");
            close();
            dispatch(setTrue());
        } catch (error) {
            toast.error("Something went wrong");
        }
    };

    return (
        <Dialog open={isOpen} onClose={close} as="div" className="z-50">
            <div className="fixed inset-0 z-10 overflow-y-auto bg-black/55 backdrop-blur-sm">
                <div className="flex min-h-full items-center justify-center p-4">
                    <DialogPanel className="mx-auto w-[90%] sm:w-[60%] xl:w-[30%] 2xl:w-[28%] rounded-2xl border border-bordercolor bg-primary shadow-lg backdrop-blur-2xl">
                        <ModalHeader title="Update Subscription Plan" onClose={close} />
                        <div className="w-full grid gap-3 px-4 pb-4 mt-8">
                            {/* Plan Name */}
                            <div className="flex flex-col gap-2">
                                <label className="font-poppins text-sm font-medium text-textcolor">
                                    Plan Name <span className="text-[#F21818]">*</span>
                                </label>
                                <input
                                    type="text"
                                    value={planName}
                                    onChange={(e) => setPlanName(e.target.value)}
                                    placeholder="Enter plan name"
                                    className="w-full rounded-lg border border-bordercolor bg-primary px-4 py-2.5 placeholder:text-placeholdercolor text-textcolor placeholder:text-sm focus:outline-none focus:ring-1 focus:ring-header"
                                />
                            </div>

                            {/* Plan Sub Text (Textarea) */}
                            <div className="flex flex-col gap-2">
                                <label className="font-poppins text-sm font-medium text-textcolor">
                                    Plan Sub Text <span className="text-[#F21818]">*</span>
                                </label>
                                <textarea
                                    rows={3}
                                    value={subText}
                                    onChange={(e) => setSubText(e.target.value)}
                                    placeholder="Enter sub text"
                                    className="w-full rounded-lg border border-bordercolor bg-primary px-4 py-2.5 placeholder:text-placeholdercolor text-textcolor placeholder:text-sm resize-none focus:outline-none focus:ring-1 focus:ring-header"
                                />
                            </div>

                            {/* Plan Price */}
                            <div className=" w-full gap-3  grid md:grid-cols-2">
                                <div className="flex flex-col gap-2">
                                    <label className="font-poppins text-sm font-medium text-textcolor">
                                        Plan Price  <span className="text-[#F21818]">*</span>
                                    </label>
                                    <input
                                        type="text"
                                        min={0}
                                        value={price}
                                        onChange={(e) => setPrice(e.target.value)}
                                        placeholder="Enter price"
                                        className="w-full rounded-lg border border-bordercolor bg-primary px-4 py-2.5 placeholder:text-placeholdercolor text-textcolor placeholder:text-sm focus:outline-none focus:ring-1 focus:ring-header"
                                    />
                                </div>
                                <DurationUpdate />
                            </div>

                            <AddSubcriptionplandec />


                            {/* Submit Button */}
                            <div className="flex justify-center">
                                <button
                                    onClick={handleSubmit}
                                    disabled={loading}
                                    className="px-10 py-2 rounded-xl cursor-pointer bggradient font-poppins text-white disabled:opacity-50"
                                >
                                    {loading ? "Submitting..." : "Submit"}
                                </button>
                            </div>
                        </div>
                    </DialogPanel>
                </div>
            </div>
        </Dialog>
    );
}

export default SubscriptionPlanUpdateModal;
