import { Dialog, DialogPanel } from "@headlessui/react";
import toast from "react-hot-toast";
import { useEffect } from "react";
import useApiPost from "../../../Hooks/PostData";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { hideModal } from "../../../Appstore/Slice/ModalSlice";
import ModalHeader from "../ModalHeader";
import AvatarWithSpinner from "../../LoadingComponest";

function CategoryListValuesShowModal() {
    const isOpen = useAppSelector(
        (state) => state.modals.CategoryListValuesShowModal
    );
    const dispatch = useAppDispatch();
    const { postData, loading, data } = useApiPost();

    const closeModal = () => dispatch(hideModal("CategoryListValuesShowModal"));

    useEffect(() => {
        const catid = sessionStorage.getItem("catid");
        if (catid) {
            const formData = new FormData();
            formData.append("cat_id", catid);
            postData("/view-category", formData);
        } else {
            toast.error("Category ID not found in session");
        }
    }, []);

    const category = data?.category;
    const subcategories = data?.subcategories;

    return (
        <Dialog open={isOpen} onClose={closeModal} className="z-50">
            <div className="fixed inset-0 z-10 bg-black/55 backdrop-blur-sm overflow-y-auto">
                <div className="flex min-h-full items-center justify-center p-4">
                    <DialogPanel className="mx-auto w-[90%] sm:w-[60%] xl:w-[30%] 2xl:w-[28%] border border-bordercolor rounded-2xl bg-primary shadow-xl">
                        <ModalHeader title="Category Details" onClose={closeModal} />

                        <div className="p-5 space-y-6">
                            {loading ? (
                                <div className=" h-[400px] flex items-center justify-center  ">
                                    <AvatarWithSpinner />
                                </div>
                            ) : (
                                <>
                                    {category && (
                                        <div className="space-y-3 text-textcolor">
                                            <h2 className="text-xl font-medium font-poppins">{category.category_name}</h2>
                                            <div className="rounded-lg overflow-hidden border p-2 border-bordercolor">
                                                <img
                                                    src={category.category_image}
                                                    alt={category.category_name}
                                                    className="w-full h-44  object-contain"
                                                />
                                            </div>
                                        </div>
                                    )}

                                    {subcategories && subcategories.length > 0 && (
                                        <div className="space-y-3">
                                            <h3 className="text-lg font-medium font-poppins text-textcolor">Subcategories:</h3>
                                            <div className="overflow-x-auto rounded-lg border border-bordercolor">
                                                <table className="min-w-full divide-y divide-bordercolor text-sm text-textcolor">
                                                    <thead className=" bg-primary text-left font-medium   text-textcolor font-poppins">
                                                        <tr>
                                                            <th className="px-4 py-3">Image</th>
                                                            <th className="px-4 py-3">Subcategory Name</th>
                                                            <th className="px-4 py-3">Services Count</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody className="bg-primary divide-y divide-bordercolor">
                                                        {subcategories.map((sub: any) => (
                                                            <tr
                                                                key={sub.id}
                                                                className="hover:bg-secondary/30 transition-colors"
                                                            >
                                                                <td className="px-4 py-3">
                                                                    <img
                                                                        src={sub.subcategory_image}
                                                                        alt={sub.subcategory_name}
                                                                        className="w-12 h-12 rounded object-cover"
                                                                    />
                                                                </td>
                                                                <td className="px-4 py-3">{sub.subcategory_name}</td>
                                                                <td className=" pl-[3rem] py-3 ">{sub.services_count}</td>
                                                            </tr>
                                                        ))}
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    )}
                                </>
                            )}
                        </div>
                    </DialogPanel>
                </div>
            </div>
        </Dialog>
    );
}

export default CategoryListValuesShowModal;
