import { Dialog, DialogPanel } from "@headlessui/react";
import toast from "react-hot-toast";
import { useState } from "react";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import useApiPost from "../../../Hooks/PostData";
import { hideModal } from "../../../Appstore/Slice/ModalSlice";
import { setTrue } from "../../../Appstore/Slice/toggleSlice";
import ModalHeader from "../ModalHeader";
import SliderImageinput from "./SliderImageinput";
import StatusVendor from "../../../Pages/AddVendor/StatusVendor";

function AddSliderModal() {
    const modalData = useAppSelector((state) => state.modals.AddSliderModal);
    const dispatch = useAppDispatch();

    const coverImage = useAppSelector((state) => state.AddImageSlice.cover_image);
    const status = useAppSelector((state) => state.addVendor.status);

    const [description, setDescription] = useState("");
    const { postData, loading } = useApiPost();

    const close = () => dispatch(hideModal("AddSliderModal"));


    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleSubmit = async () => {

        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        if (!description.trim()) {
            toast.error("Description is required");
            return;
        }

        if (!coverImage) {
            toast.error("Image is required");
            return;
        }

        if (status === "null") {
            return toast.error("Please select a status.");
        }

        const formData = new FormData();
        formData.append("description", description);
        formData.append("image", coverImage);
        formData.append("status", status ?? "");

        try {
            await postData("/add-slider", formData, true);
            toast.success("Slider added successfully");
            close();
            dispatch(setTrue());
        } catch (error) {
            toast.error("Something went wrong");
        }
    };

    return (
        <Dialog open={modalData} onClose={close} as="div" className="z-50">
            <div className="fixed inset-0 z-10 overflow-y-auto bg-black/55 backdrop-blur-sm">
                <div className="flex min-h-full items-center justify-center p-4">
                    <DialogPanel className="w-[90%] sm:w-[60%] xl:w-[30%] 2xl:w-[28%] mx-auto rounded-2xl border border-bordercolor bg-primary shadow-lg backdrop-blur-2xl duration-300">
                        <ModalHeader title="Add Slider" onClose={close} />

                        <div className="grid gap-4 px-4 pb-4 mt-8">
                            <SliderImageinput />

                            {/* Description Field */}
                            <div className="flex flex-col gap-2">
                                <label className="font-poppins text-sm font-medium text-textcolor">
                                    Description<span className="text-[#F21818] pl-1">*</span>
                                </label>
                                <textarea
                                    value={description}
                                    onChange={(e) => setDescription(e.target.value)}
                                    placeholder="Enter description..."
                                    rows={4}
                                    className="w-full rounded-lg border border-bordercolor bg-primary px-4 py-2.5 text-sm text-textcolor placeholder:text-placeholdercolor focus:outline-none focus:ring-1 focus:ring-header resize-none"
                                />
                            </div>

                            <StatusVendor />

                            {/* Submit Button */}
                            <div className="flex justify-center">
                                <button disabled={loading} onClick={handleSubmit} className="px-10 py-2 rounded-xl cursor-pointer bggradient font-poppins text-white disabled:opacity-50">
                                    {loading ? "Submitting..." : "Submit"}
                                </button>
                            </div>
                        </div>
                    </DialogPanel>
                </div>
            </div>
        </Dialog>
    );
}

export default AddSliderModal;
