import { Dialog, DialogPanel } from "@headlessui/react";
import toast from "react-hot-toast";
import { useState } from "react";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { hideModal } from "../../Appstore/Slice/ModalSlice";
import { setTrue } from "../../Appstore/Slice/toggleSlice";
import ModalHeader from "./ModalHeader";

function AddCurrencyModal() {
    const isOpen = useAppSelector((state) => state.modals.AddCurrencyModal);
    const dispatch = useAppDispatch();

    const [fullName, setFullName] = useState("");
    const [role, setRole] = useState("");
    const { postData, loading } = useApiPost();

    const close = () => dispatch(hideModal("AddCurrencyModal"));

    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleSubmit = async () => {

        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        if (!fullName || !role) {
            toast.error("Please fill all required fields");
            return;
        }

        const formData = new FormData();
        formData.append("name", fullName);
        formData.append("currency", role);

        try {
            await postData("/add-currency", formData, true);
            toast.success("Review added successfully");
            close();
            dispatch(setTrue());
        } catch (error) {
            toast.error("Something went wrong");
        }
    };

    return (
        <Dialog open={isOpen} onClose={close} as="div" className="z-50">
            <div className="fixed inset-0 z-10 overflow-y-auto bg-black/55 backdrop-blur-sm">
                <div className="flex min-h-full items-center justify-center p-4">
                    <DialogPanel className="mx-auto w-[90%] sm:w-[60%] xl:w-[30%] 2xl:w-[28%] h-fit border border-bordercolor rounded-2xl bg-primary shadow-lg backdrop-blur-2xl duration-300 ease-out">
                        <ModalHeader title="Add Currency" onClose={close} />

                        <div className="w-full grid gap-4 px-4 pb-5 mt-6">
                            {/* Full Name */}
                            <div className="flex flex-col gap-2">
                                <label className="font-poppins text-sm font-medium text-textcolor">
                                    Currency Name <span className="text-[#F21818]">*</span>
                                </label>
                                <input
                                    type="text"
                                    value={fullName}
                                    onChange={(e) => setFullName(e.target.value)}
                                    placeholder="Enter Currency Name"
                                    className="w-full rounded-lg border border-bordercolor bg-primary text-textcolor px-4 py-2.5 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none focus:ring-1 focus:ring-header"
                                />
                            </div>

                            {/* Role */}
                            <div className="flex flex-col gap-2">
                                <label className="font-poppins text-sm font-medium text-textcolor">
                                    Currency Symbol <span className="text-[#F21818]">*</span>
                                </label>
                                <input
                                    type="text"
                                    value={role}
                                    onChange={(e) => setRole(e.target.value)}
                                    placeholder="Enter Currency Symbol"
                                    className="w-full rounded-lg border border-bordercolor bg-primary text-textcolor px-4 py-2.5 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none focus:ring-1 focus:ring-header"
                                />
                            </div>
                            {/* Submit Button */}
                            <div className="flex justify-center">
                                <button
                                    disabled={loading}
                                    onClick={handleSubmit}
                                    className="px-10 py-2 cursor-pointer rounded-xl bggradient font-poppins text-white disabled:opacity-50"
                                >
                                    {loading ? "Submitting..." : "Submit"}
                                </button>
                            </div>
                        </div>
                    </DialogPanel>
                </div>
            </div>
        </Dialog>
    );
}

export default AddCurrencyModal;
