import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface StoreImage {
    id: number;
    store_images: string;
}

interface StoreAttachment {
    id: number;
    store_attachments: string;
}

interface StoreState {
    id: number | null;
    service_id: string;
    store_name: string;
    store_description: string;
    subcategory_id: number | null;
    price: string;
    created_at: string;
    updated_at: string;
    subcategory_name: string | null;
    storeImages: StoreImage[];
    storeAttachments: StoreAttachment[];
}

const initialState: StoreState = {
    id: null,
    service_id: "",
    store_name: "",
    store_description: "",
    subcategory_id: null,
    price: "",
    created_at: "",
    updated_at: "",
    subcategory_name: null,
    storeImages: [],
    storeAttachments: [],
};

const storeSliceUpdate = createSlice({
    name: "storeSliceUpdate",
    initialState,
    reducers: {
        setStore(state, action: PayloadAction<StoreState>) {
            return { ...action.payload };
        },
        updateStoreField(
            state,
            action: PayloadAction<{ key: keyof StoreState; value: any }>
        ) {
            const { key, value } = action.payload;
            (state[key] as any) = value;
        },
        addStoreImage(state, action: PayloadAction<StoreImage>) {
            state.storeImages.push(action.payload);
        },
        removeStoreImage(state, action: PayloadAction<number>) {
            state.storeImages = state.storeImages.filter(img => img.id !== action.payload);
        },
        addStoreAttachment(state, action: PayloadAction<StoreAttachment>) {
            state.storeAttachments.push(action.payload);
        },
        removeStoreAttachment(state, action: PayloadAction<number>) {
            state.storeAttachments = state.storeAttachments.filter(att => att.id !== action.payload);
        },
        resetStore() {
            return initialState;
        },
    },
});

export const {
    setStore,
    updateStoreField,
    addStoreImage,
    removeStoreImage,
    addStoreAttachment,
    removeStoreAttachment,
    resetStore,
} = storeSliceUpdate.actions;

export default storeSliceUpdate.reducer;
