// storeServiceSlice.ts
import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';
import type { ServiceDetails } from '../../Types/Types';

interface StoreServiceState {
  serviceDetails: ServiceDetails | null;
}

const initialState: StoreServiceState = {
  serviceDetails: null,
};

const storeServiceSlice = createSlice({
  name: 'storeServiceSlice',
  initialState,
  reducers: {
    setServiceDetails(state, action: PayloadAction<ServiceDetails>) {
      state.serviceDetails = action.payload;
    },
    clearServiceDetails(state) {
      state.serviceDetails = null;
    },
  },
});

export const { setServiceDetails, clearServiceDetails } = storeServiceSlice.actions;
export default storeServiceSlice.reducer;
