// Appstore/Slice/currencySlice.ts
import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';

export interface Currency {
  currency: string;
  name: string;
}

interface Pagination {
  total_pages: number;
  total_records: number;
  current_page: number;
  records_per_page: number;
}

interface CurrencyState {
  currencies: Currency[];
  pagination: Pagination | null;
  loading: boolean;
  error: string | null;
  selectedCurrency: Currency | null;
}

const initialState: CurrencyState = {
  currencies: [],
  pagination: null,
  loading: false,
  error: null,
  selectedCurrency: null,
};

const currencySlice = createSlice({
  name: 'currency',
  initialState,
  reducers: {
    fetchCurrenciesStart(state) {
      state.loading = true;
      state.error = null;
    },
    fetchCurrenciesSuccess(state, action: PayloadAction<{ currencies: Currency[]; pagination: Pagination }>) {
      state.currencies = action.payload.currencies;
      state.pagination = action.payload.pagination;
      state.loading = false;
    },
    fetchCurrenciesFailure(state, action: PayloadAction<string>) {
      state.loading = false;
      state.error = action.payload;
    },
    setSelectedCurrency(state, action: PayloadAction<Currency | null>) {
      state.selectedCurrency = action.payload;
    },
  },
});

export const {
  fetchCurrenciesStart,
  fetchCurrenciesSuccess,
  fetchCurrenciesFailure,
  setSelectedCurrency,
} = currencySlice.actions;

export default currencySlice.reducer;
