// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
    cover_images: File[];
}

const initialState: AddPostStateType = {
    cover_images: [],
};

const UploadAddserviceImageSlice = createSlice({
    name: "UploadAddserviceImageSlice",
    initialState,
    reducers: {
        updateAddserviceImages(state, action: PayloadAction<File[]>) {
            state.cover_images = [...state.cover_images, ...action.payload];
        },
        removeCoverImageByIndex(state, action: PayloadAction<number>) {
            state.cover_images.splice(action.payload, 1);
        },
        clearAllCoverImages(state) {
            state.cover_images = [];
        },
    },
});

export const {
    updateAddserviceImages,
    removeCoverImageByIndex,
    clearAllCoverImages,
} = UploadAddserviceImageSlice.actions;

export default UploadAddserviceImageSlice.reducer;
