// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const UpdateSubCategoryImageSlice = createSlice({
  name: "UpdateSubCategoryImageSlice",
  initialState,
  reducers: {
    updateCoverImageSubCategory(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImageSub(state) {
      state.cover_image = null;
    },
  },
});

export const { updateCoverImageSubCategory, clearCoverImageSub } = UpdateSubCategoryImageSlice.actions;
export default UpdateSubCategoryImageSlice.reducer;
