// store: UpdateSelectedStoreIDSlice.ts
import { createSlice } from "@reduxjs/toolkit";

interface StoreItem {
  id: number;
  service_name: string;
}

interface StoreState {
  selectedCategories: StoreItem[];
}

const initialState: StoreState = {
  selectedCategories: [],
};

const UpdateSelectedStoreIDSlice = createSlice({
  name: "UpdateSelectedStoreIDSlice",
  initialState,
  reducers: {
    toggleUpdateselectedstoreid: (state, action) => {
      const exists = state.selectedCategories.find(item => item.id === action.payload.id);
      if (exists) {
        state.selectedCategories = state.selectedCategories.filter(item => item.id !== action.payload.id);
      } else {
        state.selectedCategories.push(action.payload);
      }
    },
    clearSelectedStoreid: (state) => {
      state.selectedCategories = [];
    },
    setMultipleSelectedStores: (state, action) => {
      state.selectedCategories = action.payload; // expects an array of StoreItem
    }
  },
});

export const {
  toggleUpdateselectedstoreid,
  clearSelectedStoreid,
  setMultipleSelectedStores
} = UpdateSelectedStoreIDSlice.actions;

export default UpdateSelectedStoreIDSlice.reducer;
