// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const UpdateCategoryImageSliceFrontend3 = createSlice({
  name: "UpdateCategoryImageSliceFrontend3",
  initialState,
  reducers: {
    updateCoverImageCategoryFrontend3(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImage(state) {
      state.cover_image = null;
    },
  },
});

export const { updateCoverImageCategoryFrontend3, clearCoverImage } = UpdateCategoryImageSliceFrontend3.actions;
export default UpdateCategoryImageSliceFrontend3.reducer;
