// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const UpdateCategoryImageSliceFrontend2 = createSlice({
  name: "UpdateCategoryImageSliceFrontend2",
  initialState,
  reducers: {
    updateCoverImageCategoryFrontend2(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImage(state) {
      state.cover_image = null;
    },
  },
});

export const { updateCoverImageCategoryFrontend2, clearCoverImage } = UpdateCategoryImageSliceFrontend2.actions;
export default UpdateCategoryImageSliceFrontend2.reducer;
