// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const TestimonialImageSlice = createSlice({
  name: "TestimonialImageSlice",
  initialState,
  reducers: {
    TestimonialImageS(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImageNlytical(state) {
      state.cover_image = null;
    },
  },
});

export const { TestimonialImageS, clearCoverImageNlytical } = TestimonialImageSlice.actions;
export default TestimonialImageSlice.reducer;
