import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface SubCategoryType {
  id: number;
  category_id: number;
  subcategory_name: string;
  subcategory_image: string;
  services_count: number;
}

interface SubCategoryState {
  subCategories: SubCategoryType[];
  selectedSubCategories: SubCategoryType[]; // changed to array
}

const initialState: SubCategoryState = {
  subCategories: [],
  selectedSubCategories: [],
};

const subCategorySlice = createSlice({
  name: "subcategory",
  initialState,
  reducers: {
    setSubCategoryList: (state, action: PayloadAction<SubCategoryType[]>) => {
      state.subCategories = action.payload;
    },
    toggleSubCategorySelection: (state, action: PayloadAction<SubCategoryType>) => {
      const exists = state.selectedSubCategories.find((sc) => sc.id === action.payload.id);
      if (exists) {
        state.selectedSubCategories = state.selectedSubCategories.filter((sc) => sc.id !== action.payload.id);
      } else {
        state.selectedSubCategories.push(action.payload);
      }
    },
    removeSubCategory: (state, action: PayloadAction<number>) => {
      state.selectedSubCategories = state.selectedSubCategories.filter((sc) => sc.id !== action.payload);
    },


    resetonlyselect: (state) => {
      state.selectedSubCategories = [];
    },
    resetSubCategoryState: (state) => {
      state.subCategories = [];
      state.selectedSubCategories = [];
    },
  },
});

export const {
  setSubCategoryList,
  toggleSubCategorySelection,
  removeSubCategory,
  resetSubCategoryState,
  resetonlyselect
} = subCategorySlice.actions;

export default subCategorySlice.reducer;
