// StoreListPerfectStore.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface Category {
  id: number;
  service_name: string;
}

interface State {
  selectedCategories: Category[];
}

const initialState: State = {
  selectedCategories: [],
};

const StoreListPerfectStore = createSlice({
  name: "StoreListPerfectStore",
  initialState,
  reducers: {
    toggleCategorySelectionFronEnd12: (state, action: PayloadAction<Category>) => {
      const exists = state.selectedCategories.find(cat => cat.id === action.payload.id);
      if (exists) {
        state.selectedCategories = state.selectedCategories.filter(cat => cat.id !== action.payload.id);
      } else {
        state.selectedCategories.push(action.payload);
      }
    },
    clearSelectedCategories: (state) => {
      state.selectedCategories = [];
    },
    setSelectedCategories12: (state, action: PayloadAction<Category[]>) => {
      state.selectedCategories = action.payload;
    },
  },
});

export const {
  toggleCategorySelectionFronEnd12,
  clearSelectedCategories,
  setSelectedCategories12,
} = StoreListPerfectStore.actions;

export default StoreListPerfectStore.reducer;
