import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';

interface FAQ {
  id: number;
  question: string;
  answer: string;
}

interface SelectedFAQState {
  selectedFAQ: FAQ | null;
}

const initialState: SelectedFAQState = {
  selectedFAQ: null,
};

const selectedFAQSlice = createSlice({
  name: 'selectedFAQ',
  initialState,
  reducers: {
    setSelectedFAQ(state, action: PayloadAction<FAQ>) {
      state.selectedFAQ = action.payload;
    },
    clearSelectedFAQ(state) {
      state.selectedFAQ = null;
    },
  },
});

export const { setSelectedFAQ, clearSelectedFAQ } = selectedFAQSlice.actions;
export default selectedFAQSlice.reducer;
